/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.NxParser;

public class GetURIs {
    public static void main(String[] args) throws URISyntaxException, IOException {
        Option inputO = new Option("i", "name of file to read, - for stdin");
        inputO.setArgs(1);
        Option outputO = new Option("o", "name of file to write, - for stdout");
        outputO.setArgs(1);
        Option uniqueO = new Option("u", "try to unique as much as possible");
        uniqueO.setArgs(1);
        Option bnO = new Option("b", "also print blank nodes");
        bnO.setArgs(0);
        Option helpO = new Option("h", "print help");
        Options options = new Options();
        options.addOption(inputO);
        options.addOption(outputO);
        options.addOption(uniqueO);
        options.addOption(bnO);
        options.addOption(helpO);
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("***ERROR: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        if (cmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        InputStream in = System.in;
        PrintStream out = System.out;
        if (cmd.hasOption("i")) {
            in = cmd.getOptionValue("i").equals("-") ? System.in : new FileInputStream(cmd.getOptionValue("i"));
        }
        if (cmd.hasOption("o")) {
            out = cmd.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(cmd.getOptionValue("o")));
        }
        NxParser nqp = new NxParser(in, false);
        HashMap<Node, Boolean> ht = new HashMap<Node, Boolean>();
        while (nqp.hasNext()) {
            Node[] ns = nqp.next();
            for (int i = 0; i < ns.length; ++i) {
                if (ns[i] instanceof Resource) {
                    if (cmd.hasOption("u") && ns[i] instanceof Resource) {
                        if (ht.containsKey(ns[i])) continue;
                        ht.put(ns[i], Boolean.TRUE);
                    }
                    out.println(ns[i].toString());
                    continue;
                }
                if (!cmd.hasOption("b") || !(ns[i] instanceof BNode)) continue;
                out.println(ns[i].toString());
            }
        }
    }
}

