/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.util.NxUtil;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;

public class FixBNodes2 {
    static Logger _log = Logger.getLogger(FixBNodes2.class.getName());

    public static void main(String[] args) throws URISyntaxException, IOException {
        Options options = Main.getStandardOptions();
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("***ERROR: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        if (cmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        InputStream is = Main.getMainInputStream(cmd);
        NxParser nxp = new NxParser(is);
        OutputStream os = Main.getMainOutputStream(cmd);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        CallbackNxBufferedWriter cb = new CallbackNxBufferedWriter(bw);
        int ticks = Main.getTicks(cmd);
        int c = 0;
        while (nxp.hasNext()) {
            Node[] nx = nxp.next();
            if (++c % ticks == 0) {
                _log.info("Read " + c + " lines");
            }
            for (int i = 0; i < nx.length; ++i) {
                if (!(nx[i] instanceof Resource)) continue;
                String nxs = nx[i].toN3();
                if (nxs.startsWith("<node") && !nxs.contains(":") && nxs.length() > 6) {
                    nx[i] = BNode.createBNode(nx[3].toString(), nx[i].toN3().substring(1, nxs.length() - 1));
                    _log.info("Fixing bnode " + nxs + " to " + nx[i].toN3() + " in doc " + nx[3]);
                    continue;
                }
                nx[i] = new Resource(NxUtil.escapeForNx(nx[i].toString()));
            }
            cb.processStatement(nx);
        }
        _log.info("Finished. Read " + c + " lines");
        bw.close();
    }
}

