/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.util.NxUtil;

public class Resource
implements Node,
Serializable {
    private static Logger _log = Logger.getLogger(Resource.class.getName());
    protected String _data;
    public static final long serialVersionUID = 1L;

    public Resource() {
        this._data = null;
    }

    public Resource(String uri) {
        this(uri, false);
    }

    public Resource(URI uri) {
        this("<" + NxUtil.escapeForNx(uri.toASCIIString()) + ">", true);
    }

    public Resource(String uri, boolean isN3) {
        if (!isN3) {
            if (uri.length() == 0 || uri == null) {
                _log.severe("The supplied String for creating a resource was " + (uri == null ? "the null pointer" : "the empty string, which MUST NOT be the case in Nx."));
                this._data = uri == null ? null : "";
                return;
            }
            this._data = uri.charAt(0) != '<' ? "<" + uri + ">" : uri;
        } else {
            this._data = uri;
        }
    }

    public String getHost() throws URISyntaxException {
        URI u = new URI(this.toN3().substring(1, this.toN3().length() - 1));
        return u.getHost();
    }

    public int hashCode() {
        return this.toN3().hashCode();
    }

    public String toString() {
        return NxUtil.unescape(this.toN3().substring(1, this.toN3().length() - 1));
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toN3() {
        return this._data;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof Resource) {
            Resource r = (Resource)o;
            return this.toN3().compareTo(r.toN3());
        }
        if (o instanceof Literal) {
            return Integer.MAX_VALUE;
        }
        if (o instanceof BNode) {
            return -715827882;
        }
        if (o instanceof Unbound) {
            return -1073741824;
        }
        if (o instanceof Variable) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type Resource but " + o.getClass().getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Resource) {
            Resource r = (Resource)o;
            return r.toN3().equals(this.toN3());
        }
        return false;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        if (!this._data.startsWith("<") || !this._data.endsWith(">")) {
            this._data = "<" + this._data + ">";
        }
    }

    public static boolean equals(String a, String b) {
        if (a == b) {
            return true;
        }
        int n = a.length();
        if (n == b.length()) {
            while (--n >= 0) {
                if (a.charAt(n) == b.charAt(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

