/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.util.NxUtil;

public class Literal
implements Node,
Serializable {
    private static Logger _log = Logger.getLogger(Literal.class.getName());
    protected String _data = null;
    protected String _lang = null;
    protected Resource _dt = null;
    protected String _wholeString = null;
    @Deprecated
    public static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    @Deprecated
    public static final Resource STRING = new Resource("http://www.w3.org/2001/XMLSchema#string");
    @Deprecated
    public static final Resource BOOLEAN = new Resource("http://www.w3.org/2001/XMLSchema#boolean");
    @Deprecated
    public static final Resource FLOAT = new Resource("http://www.w3.org/2001/XMLSchema#float");
    @Deprecated
    public static final Resource DECIMAL = new Resource("http://www.w3.org/2001/XMLSchema#decimal");
    @Deprecated
    public static final Resource DOUBLE = new Resource("http://www.w3.org/2001/XMLSchema#double");
    @Deprecated
    public static final Resource DATETIME = new Resource("http://www.w3.org/2001/XMLSchema#dateTime");
    private static final Pattern PATTERN = Pattern.compile("(?:\"(.*)\")(?:@([a-zA-Z]+(?:-[a-zA-Z0-9]+)*)|\\^\\^(<\\S+>))?");
    private static final long serialVersionUID = 8911891129019471564L;

    public Literal(String data) {
        this(data, null, null);
    }

    public Literal(String data, String lang) {
        this(data, lang, null);
    }

    public Literal(String data, Resource dt) {
        this(data, null, dt);
    }

    public Literal(String data, String lang, Resource dt) {
        this(data, lang, dt, false);
    }

    public Literal(String data, String lang, Resource dt, boolean isN3) {
        if (!isN3) {
            if (data.equals("") || data.charAt(0) != '\"' || data.charAt(data.length() - 1) != '\"') {
                _log.fine("String for Literal (" + data + ") had no surrounding quotes. Adding some and proceeding...");
                data = '\"' + data + '\"';
            }
            if (lang != null && !"".equals(lang) && dt != null) {
                throw new IllegalArgumentException("In Nx, only one of language and datatype can be given.");
            }
            this._wholeString = data + (lang == null || "".equals(lang) ? (dt == null ? "" : "^^" + dt.toN3()) : "@" + lang);
            if (dt != null) {
                this._dt = dt;
            }
        } else {
            this._wholeString = data;
        }
    }

    public Literal(String data, boolean isN3) {
        this(data, null, null, isN3);
    }

    public String getData() {
        if (this._data == null) {
            Matcher m = PATTERN.matcher(this._wholeString);
            if (m.matches()) {
                this._data = m.group(1);
            } else {
                _log.warning("Something wrong with the literal-backing string. The parsing regex pattern didn't match. Check the string for correct N3 syntax. The malicious string is: " + this._wholeString);
                int lastIndex = this._wholeString.lastIndexOf(34);
                if (lastIndex > 0) {
                    return this._wholeString.substring(1, lastIndex);
                }
                return this._wholeString;
            }
        }
        return this._data;
    }

    public String getMarkupEscapedData() {
        return NxUtil.escapeForMarkup(this.getData());
    }

    public String getUnescapedData() {
        return NxUtil.unescape(this.getData());
    }

    public String getLanguageTag() {
        if (this._lang == null) {
            Matcher m = PATTERN.matcher(this._wholeString);
            if (!m.matches()) {
                _log.warning("The parsing regex pattern didn't match, so no language tag is returned. Check the Literal for proper N3 syntax. The malicious Literal was: " + this._wholeString);
            } else {
                this._lang = m.group(2);
            }
        }
        return this._lang;
    }

    public boolean isConstant() {
        return true;
    }

    public Resource getDatatype() {
        if (this._dt == null) {
            Matcher m = PATTERN.matcher(this._wholeString);
            if (m.matches()) {
                if (m.group(3) == null) {
                    return null;
                }
                this._dt = new Resource(m.group(3), true);
            } else {
                _log.warning("Something wrong with the Resource. Its String: " + this._wholeString + " didn't match the parsing regex pattern. Probably it's no proper N3.");
            }
        }
        return this._dt;
    }

    public String toString() {
        return NxUtil.unescape(this.getData());
    }

    public String toN3() {
        return this._wholeString;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof Literal) {
            Literal l = (Literal)o;
            return this._wholeString.compareTo(l._wholeString);
        }
        if (o instanceof Resource) {
            return -536870912;
        }
        if (o instanceof BNode) {
            return -715827882;
        }
        if (o instanceof Unbound) {
            return -1073741824;
        }
        if (o instanceof Variable) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type Literal but " + o.getClass().getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o != null && o instanceof Literal && ((Literal)o)._wholeString.equals(this._wholeString);
    }

    public int hashCode() {
        return this._wholeString.hashCode();
    }

    protected int getHashCode() {
        return this.hashCode();
    }

    public static String escapeForNx(String lit) {
        return NxUtil.escapeForNx(lit);
    }

    public static String escapeForMarkup(String lit) {
        return NxUtil.escapeForMarkup(lit);
    }

    public static String unescape(String str) {
        return NxUtil.unescape(str);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }
}

