/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

public class DateLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    public static final Resource DATE = new Resource("http://www.w3.org/2001/XMLSchema#date");
    Date _date;

    public DateLiteral(String date) throws ParseException, NumberFormatException {
        super(date, DATE);
        this._date = DateLiteral.parseISO8601(date);
    }

    public Date getDate() {
        return this._date;
    }

    public int compareTo(DateLiteral dtl) {
        return this.toString().compareTo(dtl.toString());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static Date parseISO8601(String s) throws ParseException {
        StringTokenizer t = new StringTokenizer(s, "-T:.Z+", true);
        if (t == null || t.countTokens() == 0) {
            throw new ParseException("parseISO8601: Cannot parse '" + s + "'");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        try {
            String tok = t.nextToken();
            try {
                Integer year = Integer.parseInt(tok);
                if (year / 2000 > 1) {
                    throw new ParseException("parseISO8601: year seems bogus '" + year + "'");
                }
                cal.set(1, year);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("parseISO8601: Cannot parse '" + s + "'");
            }
            if (!t.hasMoreTokens()) {
                return cal.getTime();
            }
            if (!t.nextToken().equals("-")) {
                return cal.getTime();
            }
            cal.set(2, Integer.parseInt(t.nextToken()) - 1);
            if (!t.hasMoreTokens()) {
                return cal.getTime();
            }
            if (!t.nextToken().equals("-")) {
                return cal.getTime();
            }
            cal.set(5, Integer.parseInt(t.nextToken()));
            if (!t.hasMoreTokens()) {
                return cal.getTime();
            }
            if (t.nextToken().equals("T")) {
                int hour = Integer.parseInt(t.nextToken());
                int min = 0;
                int sec = 0;
                int msec = 0;
                if (t.nextToken().equals(":")) {
                    int offset;
                    min = Integer.parseInt(t.nextToken());
                    String token = t.nextToken();
                    if (token.equals(":")) {
                        sec = Integer.parseInt(t.nextToken());
                        token = t.nextToken();
                        if (token.equals(".")) {
                            msec = Integer.parseInt(t.nextToken());
                            token = t.nextToken();
                        }
                    }
                    if (token.equals("Z")) {
                        offset = 0;
                    } else {
                        int sign = 0;
                        if (token.equals("+")) {
                            sign = 1;
                        } else if (token.equals("-")) {
                            sign = -1;
                        } else {
                            return cal.getTime();
                        }
                        offset = sign * Integer.parseInt(t.nextToken()) * 10 * 3600;
                    }
                    cal.set(15, offset);
                }
                cal.set(11, hour);
                cal.set(12, min);
                cal.set(13, sec);
                cal.set(14, msec);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!cal.isSet(1)) {
            throw new ParseException("parseISO8601: Cannot parse '" + s + "'");
        }
        return cal.getTime();
    }
}

