/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dotgraph;

import de.xam.dotgraph.Edge;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Graph
implements Comparable<Graph> {
    private ILabelRenderer labelRenderer = new ILabelRenderer(){

        @Override
        public String render(String s) {
            return s;
        }
    };
    private final String name;
    private final Set<Edge> edges = new HashSet<Edge>();
    private final SortedSet<Graph> subgraphs = new TreeSet<Graph>();
    private final Set<String> nodes = new HashSet<String>();
    public boolean concentrateEdges = false;

    public void setLabelRenderer(ILabelRenderer labelRenderer) {
        this.labelRenderer = labelRenderer;
    }

    public Graph(String name) {
        this.name = name;
    }

    public void addNode(String n) {
        this.nodes.add(n);
    }

    public void addEdge(String a, String b, int weight, String edgeLabel) {
        Edge e = new Edge(a, b, weight, edgeLabel);
        this.edges.add(e);
    }

    public Graph createSubgraph(String name) {
        Graph g = new Graph(name);
        g.setLabelRenderer(this.labelRenderer);
        this.subgraphs.add(g);
        return g;
    }

    private void writeAsMainGraph(Writer w) throws IOException {
        w.write("digraph " + this.getLabel() + " {\n");
        Graph.writeGraphAttribute(w, "size", "10,10");
        Graph.writeGraphAttribute(w, "concentrate", "" + this.concentrateEdges);
        Graph.writeGraphAttribute(w, "remincross", "true");
        Graph.writeGraphAttribute(w, "searchsize", "100");
        this.writeContent(w);
        w.write("}");
    }

    private static void writeGraphAttribute(Writer w, String key, String value) throws IOException {
        w.write(key + "=\"" + value + "\"\n");
    }

    private void writeContent(Writer w) throws IOException {
        if (this.nodes.size() > 0) {
            for (String n : this.nodes) {
                w.write(this.labelRenderer.render(n) + ";\n");
            }
        }
        for (Edge e : this.edges) {
            e.write(w, this.labelRenderer);
        }
        for (Graph subgraph : this.subgraphs) {
            if (subgraph.size() <= 0) continue;
            subgraph.writeAsSubGraph(w);
        }
    }

    private void writeAsSubGraph(Writer w) throws IOException {
        w.write("subgraph " + this.getLabel() + " { \n" + "label=" + this.getLabel() + "\n");
        this.writeContent(w);
        w.write("}\n");
    }

    private String getLabel() {
        if (this.name.equals("")) {
            return "ROOT";
        }
        return "cluster_" + this.name.replace('.', '_');
    }

    public int size() {
        int i = this.edges.size();
        for (Graph g : this.subgraphs) {
            i += g.size();
        }
        return i;
    }

    public void writeTo(File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, "utf-8");
        this.writeAsMainGraph(w);
        ((Writer)w).close();
        fos.close();
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Graph) {
            Graph oGraph = (Graph)o;
            return oGraph.getLabel().equals(this.getLabel());
        }
        return false;
    }

    public void dump(String indent) {
        System.out.println(indent + this.getLabel());
        for (Edge e : this.edges) {
            System.out.println(indent + e.getSource() + " -> " + e.getTarget() + " causes: " + e.getEdgeLabel());
        }
        for (Graph sub : this.subgraphs) {
            sub.dump(indent + "  ");
        }
    }

    @Override
    public int compareTo(Graph o) {
        return this.getLabel().compareTo(o.getLabel());
    }

    public String toString() {
        return this.getLabel() + " (" + this.size() + ")";
    }

    public void pruneEmptySubGraphs() {
        if (this.subgraphs.size() > 0) {
            LinkedList<Graph> toBeDeleted = new LinkedList<Graph>();
            for (Graph sub : this.subgraphs) {
                sub.pruneEmptySubGraphs();
                if (!sub.isEmpty()) continue;
                toBeDeleted.add(sub);
            }
            for (Graph sub : toBeDeleted) {
                this.subgraphs.remove(sub);
            }
        }
    }

    private boolean isEmpty() {
        return this.subgraphs.isEmpty() && this.edges.isEmpty() && this.nodes.isEmpty();
    }

    public static interface ILabelRenderer {
        public String render(String var1);
    }
}

