/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.sink;

import com.google.common.base.Joiner;
import de.xam.texthtml.text.TextTool;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenSink;
import de.xam.tokenpipe.user.pipe.TokenDefs;
import de.xam.tokenpipe.user.pipe.link.LinkType;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkListener;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkToHtmlTranslator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.core.XX;
import org.xydra.core.serialize.xml.XmlEncoder;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class FlexHtmlLayerParserSink
implements ITokenSink {
    private static final Logger log = LoggerFactory.getLogger(FlexHtmlLayerParserSink.class);
    private StringBuilder resultHtml;
    public static final String[] EMPTY_TAGS = new String[]{"hr", "br", "link", "meta", "area", "base", "col", "command", "embed", "img", "input", "keygen", "param", "source", "track", "wbr"};
    public static Set<String> emptyTags = new HashSet<String>();
    public static final String[] FOLLOWED_BY_NEWLINE_TAGS = new String[]{"hr", "br", "li", "ul", "h1", "h2", "h3", "h4", "h5", "h6"};
    public static final String[] PRECEEDED_BY_NEWLINE_TAGS = new String[]{"hr", "li", "ul"};
    public static Set<String> followedByNewlineTags = new HashSet<String>();
    public static Set<String> preceededByNewlineTags = new HashSet<String>();
    private int indentDepth = 0;
    private static final String NEWLINE = "\n";
    private boolean startOfLine = true;
    private final ILinkToHtmlTranslator linkToHtmlTranslator;
    private boolean generateHtml;
    private Object parseContext;

    public FlexHtmlLayerParserSink(ILinkToHtmlTranslator linkToHtmlTranslator) {
        assert (linkToHtmlTranslator != null);
        this.linkToHtmlTranslator = linkToHtmlTranslator;
    }

    public void onToken(IToken t) {
        if (!this.generateHtml) {
            if (t.getKind() == IToken.Kind.Content && t.getType().equals("link")) {
                this.onContent_Link(t);
            }
            return;
        }
        assert (this.resultHtml != null);
        String tagName = t.getType().toLowerCase();
        switch (t.getKind()) {
            case Start: {
                if (preceededByNewlineTags.contains(tagName)) {
                    if (!this.startOfLine) {
                        this.resultHtml.append(NEWLINE);
                    }
                    this.startOfLine = true;
                }
                if (this.startOfLine) {
                    this.indent("  ");
                }
                if (emptyTags.contains(t.getType().toLowerCase())) {
                    this.emptyTag(tagName);
                } else {
                    this.openTagStart(tagName);
                    HashSet<String> classNames = new HashSet<String>();
                    for (Map.Entry entry : t.getContextAsMap().entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (key.startsWith("data-")) {
                            this.openTagAttribute(tagName, key, value);
                            continue;
                        }
                        if (key.startsWith("class-")) {
                            assert (value != null) : "key=" + key;
                            classNames.add(value);
                            continue;
                        }
                        if (!key.startsWith("copy-")) continue;
                        assert (value != null) : "key=" + key;
                        this.openTagAttribute(tagName, key.substring("copy-".length()), value);
                    }
                    if (!classNames.isEmpty()) {
                        this.openTagAttribute(tagName, "class", Joiner.on((String)" ").join(classNames));
                    }
                    this.openTagEnd();
                }
                this.startOfLine = false;
                ++this.indentDepth;
                break;
            }
            case End: {
                --this.indentDepth;
                if (!emptyTags.contains(t.getType().toLowerCase())) {
                    if (this.startOfLine) {
                        this.indent("  ");
                    }
                    this.endTag(tagName);
                    this.startOfLine = false;
                }
                if (!followedByNewlineTags.contains(tagName)) break;
                this.newline();
                break;
            }
            case Content: {
                if (t.getType().equals("link")) {
                    String linkHtml = this.onContent_Link(t);
                    this.resultHtml.append(linkHtml);
                } else {
                    this.resultHtml.append(XmlEncoder.encode((String)t.getChars()));
                }
                this.startOfLine = false;
            }
        }
    }

    private String onContent_Link(IToken t) {
        XId linkTargetId;
        assert (t.getType().equals("link"));
        String linkTargetName = t.getContextAsString("link-target-name", null);
        String linkTargetIdStr = t.getContextAsString("link-target-id", null);
        XId xId = linkTargetId = linkTargetIdStr == null ? null : XX.toId((String)linkTargetIdStr);
        assert (linkTargetName != null || linkTargetId != null);
        LinkType linkType = LinkType.valueOf(t.getContextAsString("class-type", null));
        boolean createItems = t.getContextAsBoolean("class-create-items");
        ILinkListener.LinkCause linkCause = ILinkListener.LinkCause.valueOf(t.getContextAsString("class-cause", null));
        String tokenContent = t.getChars();
        String bestLinkText = linkTargetName == null ? tokenContent : linkTargetName;
        String linkHtml = this.linkToHtmlTranslator.createLink(linkTargetName, linkTargetId, bestLinkText, linkType, linkCause, createItems, this.generateHtml, "FlexHtmlLayerParserSink-onToken-CaseContent");
        return linkHtml;
    }

    private void newline() {
        this.resultHtml.append(NEWLINE);
        this.startOfLine = true;
    }

    private void indent(String indent) {
        this.resultHtml.append(TextTool.indent((int)this.indentDepth, (String)indent));
    }

    private void emptyTag(String tagName) {
        this.resultHtml.append("<" + tagName + "/>");
    }

    private void openTagStart(String tagName) {
        this.resultHtml.append("<" + tagName);
    }

    private void openTagAttribute(String tagName, String key, String value) {
        this.resultHtml.append(" " + key + "=\"" + value + "\"");
    }

    private void openTagEnd() {
        this.resultHtml.append(">");
    }

    private void endTag(String tagName) {
        this.resultHtml.append("</" + tagName + ">");
    }

    public void onBeforeDocument() {
        this.resultHtml = new StringBuilder();
    }

    public void onAfterDocument() {
        log.debug("Done with HTML. Resulting HTML lenght = " + this.resultHtml.length());
    }

    public String[] producedTokenTypes() {
        return new String[0];
    }

    public String[] consumedTokenTypes() {
        return TokenDefs.VALUES();
    }

    public String getLabel() {
        return "htmlsink";
    }

    public void onException(Throwable e) {
        log.warn("Exception", e);
    }

    public StringBuilder getResultHtmlFragment() {
        return this.resultHtml;
    }

    public void setGenerateHtml(boolean generateHtml) {
        this.generateHtml = generateHtml;
    }

    public void setParseContext(Object parseContext) {
        this.parseContext = parseContext;
    }

    static {
        emptyTags.addAll(Arrays.asList(EMPTY_TAGS));
        followedByNewlineTags.addAll(Arrays.asList(FOLLOWED_BY_NEWLINE_TAGS));
        preceededByNewlineTags.addAll(Arrays.asList(PRECEEDED_BY_NEWLINE_TAGS));
    }
}

