/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe.link;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.Pipes;
import de.xam.tokenpipe.user.pipe.link.LinkInfo;
import de.xam.tokenpipe.user.pipe.link.LinkType;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkListener;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkToHtmlTranslator;
import org.xydra.base.XId;
import org.xydra.index.query.Pair;

public class LinkTool {
    public static void fireLink(ITokenStream stream, LinkInfo linkInfo, boolean createItem, ILinkListener optionalLinkListener, Object parseContext) {
        assert (linkInfo.getLinkText() != null);
        assert (linkInfo.getLinkCause() != null);
        assert (linkInfo.getLinkTargetName() != null || linkInfo.getLinkTargetId() != null);
        Pair nameOrIdPair = linkInfo.getLinkTargetId() == null ? new Pair((Object)"link-target-name", (Object)linkInfo.getLinkTargetName()) : new Pair((Object)"link-target-id", (Object)linkInfo.getLinkTargetId().toString());
        Pair[] pairs = new Pair[]{nameOrIdPair, new Pair((Object)"class-cause", (Object)linkInfo.getLinkCause().name()), new Pair((Object)"class-type", (Object)linkInfo.getLinkType().name()), new Pair((Object)"class-create-items", (Object)("" + createItem))};
        stream.fireToken((IToken)Pipes.token((IToken.Kind)IToken.Kind.Content, (String)"link", (String)linkInfo.getLinkText(), (Pair[])pairs));
        if (optionalLinkListener != null) {
            optionalLinkListener.onLink(linkInfo.getLinkTargetName(), linkInfo.getLinkTargetId(), linkInfo.getLinkText(), linkInfo.getLinkCause(), createItem, parseContext);
        }
    }

    public static class DummyLinkToHtmlTranslator
    implements ILinkToHtmlTranslator {
        @Override
        public String createLink(String linkTarget, XId linkTargetId, String linkText, LinkType linkType, ILinkListener.LinkCause linkCause, boolean createItems, boolean generateHtml, String creationSource) {
            StringBuilder b = new StringBuilder();
            b.append("<a");
            b.append(" href='" + (linkTarget != null ? "?target=" + linkTarget : "?id=" + linkTargetId) + "'");
            b.append(" class='" + linkCause.name() + "'");
            b.append(">");
            b.append(linkText);
            b.append("</a>");
            return b.toString();
        }
    }
}

