/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe.link;

import de.xam.texthtml.text.AnnotatedString;
import de.xam.tokenpipe.user.pipe.link.LinkInfo;
import de.xam.tokenpipe.user.pipe.link.LinkType;
import de.xam.tokenpipe.user.pipe.link.spi.IAutoLinkSearchEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xydra.base.XId;
import org.xydra.index.impl.IntegerRangeIndex;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Autolinker {
    private static final Logger log = LoggerFactory.getLogger(Autolinker.class);

    public static List<AnnotatedString.AnnotatedSpan<LinkInfo>> findAutolinkMatches(AnnotatedString<LinkInfo> annotatedContentSource, IntegerRangeIndex.Span region, IAutoLinkSearchEngine<LinkInfo, XId> autolinkSearchEngine) {
        assert (autolinkSearchEngine != null);
        final ArrayList<AnnotatedString.AnnotatedSpan<LinkInfo>> results = new ArrayList<AnnotatedString.AnnotatedSpan<LinkInfo>>();
        IAutoLinkSearchEngine.IAutoLinkReporter<XId> linkReporter = new IAutoLinkSearchEngine.IAutoLinkReporter<XId>(){

            @Override
            public void onMatch(int startInclusive, int endInclusive, XId itemId) {
                LinkInfo linkInfo = new LinkInfo(LinkType.AutoWikiLink, itemId);
                AnnotatedString.AnnotatedSpan an = new AnnotatedString.AnnotatedSpan(startInclusive, endInclusive, (Object)linkInfo);
                results.add(an);
            }
        };
        Iterator spanIt = annotatedContentSource.spanIterator(region.getStartInclusive(), region.getEndInclusive());
        ArrayList spanList = Iterators.toArrayList((Iterator)spanIt);
        for (IntegerRangeIndex.Span span : spanList) {
            if (log.isTraceEnabled()) {
                String content = annotatedContentSource.getString();
                String spanStr = content.substring(span.getStartInclusive(), span.getEndInclusive() + 1);
                log.trace("Inspecting '" + spanStr + "'");
            }
            if (span.isInRange()) continue;
            int spanStartInContentInclusive = span.getStartInclusive();
            int spanEndInContentInclusive = span.getEndInclusive();
            autolinkSearchEngine.fragmentizeAndFindLinks(annotatedContentSource, spanStartInContentInclusive, spanEndInContentInclusive, linkReporter);
        }
        return results;
    }

    public static void findAutolinkMatches(AnnotatedString<LinkInfo> annotatedContent, IAutoLinkSearchEngine<LinkInfo, XId> autolinkSearchEngine) {
        ArrayList<AnnotatedString.AnnotatedSpan<LinkInfo>> autoLinks = new ArrayList<AnnotatedString.AnnotatedSpan<LinkInfo>>();
        Iterator spanIt = annotatedContent.spanIterator(0, annotatedContent.getString().length() - 1);
        while (spanIt.hasNext()) {
            IntegerRangeIndex.Span span = (IntegerRangeIndex.Span)spanIt.next();
            if (span.isInRange()) continue;
            if (log.isTraceEnabled()) {
                log.trace("Finding auto-links in '" + annotatedContent.getString(span) + "'");
            }
            autoLinks.addAll(Autolinker.findAutolinkMatches(annotatedContent, span, autolinkSearchEngine));
        }
        for (AnnotatedString.AnnotatedSpan annotatedSpan : autoLinks) {
            annotatedContent.addAnnotation(annotatedSpan);
        }
    }
}

