/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.Pipes;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ToHtmlTokenPipe
extends AbstractTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(ToHtmlTokenPipe.class);

    public String[] consumedTokenTypes() {
        return new String[]{"document", "string", "headline", "line"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"code", "h1", "h2", "h3", "h4", "h5", "h6", "br", "inline"};
    }

    public String getLabel() {
        return "toHTml";
    }

    public void onToken(ITokenStream stream, IToken token) {
        block6 : switch (token.getType()) {
            case "document": {
                break;
            }
            case "headline": {
                assert (token.getKind() != IToken.Kind.Content);
                stream.fireToken(Pipes.token((IToken.Kind)token.getKind(), (String)("h" + Math.min(token.getContextAsInt("headlineLevel"), 6)), (Pair[])new Pair[0]));
                break;
            }
            case "line": {
                if (!token.isEnd()) break;
                String linetype = token.getContextAsString("lineType", "standard");
                if (linetype.equals("standard")) {
                    linetype = token.getStartToken().getContextAsString("lineType", "standard");
                }
                switch (linetype) {
                    case "listItem": 
                    case "headline": {
                        break block6;
                    }
                }
                stream.fireToken(Pipes.startToken((String)"br", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"obct-7")}));
                stream.fireToken(Pipes.endToken((String)"br", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"obct-8")}));
                break;
            }
            case "string": {
                switch (token.getKind()) {
                    case Content: {
                        stream.fireToken((IToken)Pipes.renameToken((IToken)token, (String)"inline"));
                        break block6;
                    }
                    case Start: {
                        stream.fireToken(Pipes.startToken((String)"code", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"obct-5")}));
                        break block6;
                    }
                    case End: {
                        stream.fireToken(Pipes.endToken((String)"code", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"obct-5")}));
                    }
                }
            }
        }
    }
}

