/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenEmitter;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import de.xam.tokenpipe.pipe.buffer.TokenBuffer;
import de.xam.tokenpipe.pipe.buffer.TwoBuffer;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class NewLineTokenPipe
extends AbstractTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(NewLineTokenPipe.class);
    private static final int NEWLINE = 10;
    private TokenBuffer tokenBuffer;
    private TwoBuffer twoBuffer;

    public String getLabel() {
        return "newline";
    }

    public String[] consumedTokenTypes() {
        return new String[]{"document", "chunk", "pre", "string"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"document", "chunk", "pre", "string", "inline", "line"};
    }

    public void onBeforeDocument() {
        this.tokenBuffer = new TokenBuffer(this.getLabel());
        this.twoBuffer = new TwoBuffer(this.getLabel(), (ITokenEmitter)this.tokenBuffer);
    }

    public void onToken(ITokenStream stream, IToken token) {
        block3 : switch (token.getType()) {
            case "document": {
                switch (token.getKind()) {
                    case Start: {
                        this.tokenBuffer.fireToken(token);
                        this.twoBuffer.fireLookBackAsStartToBuffer("line", new Pair[]{new Pair((Object)"trace", (Object)"onToken-1")});
                        break block3;
                    }
                    case Content: {
                        break block3;
                    }
                    case End: {
                        this.twoBuffer.fireCurrentContentToBuffer("inline", new Pair[]{new Pair((Object)"trace", (Object)"onToken-3")});
                        this.twoBuffer.fireLookBackAsEndToBuffer("line", new Pair[]{new Pair((Object)"trace", (Object)"onToken-2")});
                    }
                }
            }
        }
        switch (token.getType()) {
            case "document": {
                if (!token.isEnd()) break;
                this.tokenBuffer.fireToken(token);
                this.tokenBuffer.flushTokenBufferAndFireTokens(stream);
                break;
            }
            case "chunk": {
                if (token.isContent()) break;
                this.tokenBuffer.fireToken(token);
                break;
            }
            default: {
                this.tokenBuffer.fireToken(token);
            }
        }
    }

    public void onContentCodepoint(ITokenStream stream, int c, int i, IToken token) {
        if (!token.getType().equals("chunk")) {
            return;
        }
        if (c == 10) {
            this.twoBuffer.lookBack(c);
            this.twoBuffer.fireCurrentContentToBuffer("inline", new Pair[]{new Pair((Object)"inline-first-child", (Object)"true"), new Pair((Object)"trace", (Object)"onContentCodepoint-1")});
            this.twoBuffer.fireLookBackAsEndToBuffer("line", new Pair[]{new Pair((Object)"trace", (Object)"onContentCodepoint-2")});
            this.twoBuffer.fireLookBackAsStartToBuffer("line", new Pair[]{new Pair((Object)"trace", (Object)"onContentCodepoint-3")});
        } else {
            this.twoBuffer.flushLookback();
            this.twoBuffer.continueCurrentToken(c);
        }
    }

    public void onAfterContentToken(ITokenStream stream, IToken token) {
        if (!token.getType().equals("chunk")) {
            return;
        }
        this.twoBuffer.fireCurrentContentToBuffer("inline", new Pair[]{new Pair((Object)"trace", (Object)"onAfterContentToken-1")});
    }
}

