/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.Pipes;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import org.xydra.index.query.Pair;

public class ListTokenPipe
extends AbstractTokenPipe
implements ITokenPipe {
    private int currentListLevel;

    private static int endLists(ITokenStream stream, int startListLevel, int targetListLevel) {
        int c;
        for (c = startListLevel; c > targetListLevel; --c) {
            stream.fireToken(Pipes.endToken((String)"ul", (Pair[])new Pair[0]));
        }
        return c;
    }

    private static int startLists(ITokenStream stream, int startListLevel, int targetListLevel) {
        int c;
        for (c = startListLevel; c < targetListLevel; ++c) {
            stream.fireToken(Pipes.startToken((String)"ul", (Pair[])new Pair[0]));
        }
        return c;
    }

    public String getLabel() {
        return "list";
    }

    public String[] consumedTokenTypes() {
        return new String[]{"line", "listItem"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"line", "ul", "li"};
    }

    public void onBeforeDocument() {
        this.currentListLevel = 0;
    }

    public void onToken(ITokenStream stream, IToken token) {
        block17: {
            block4 : switch (token.getType()) {
                case "line": {
                    if (token.isStart()) {
                        if (token.getContextAsMap().containsKey("data-listLevel")) {
                            int targetListLevel = token.getContextAsInt("data-listLevel");
                            this.currentListLevel = ListTokenPipe.endLists(stream, this.currentListLevel, targetListLevel);
                            this.currentListLevel = ListTokenPipe.startLists(stream, this.currentListLevel, targetListLevel);
                        }
                        stream.fireToken(token);
                        break;
                    }
                    if (!token.isEnd()) break;
                    stream.fireToken(token);
                    boolean listItemLine = token.getStartToken().getContextAsString("lineType", "normal").equals("listItem");
                    if (listItemLine) break;
                    this.currentListLevel = ListTokenPipe.endLists(stream, this.currentListLevel, 0);
                    break;
                }
                case "listItem": {
                    assert (token.getKind() != IToken.Kind.Content) : "listItems only occur as Start & End";
                    switch (token.getKind()) {
                        case Content: {
                            assert (false) : "listItems only occur as Start & End";
                            break block17;
                        }
                        case Start: {
                            stream.fireToken((IToken)Pipes.renameToken((IToken)token, (String)"li"));
                            break block4;
                        }
                        case End: {
                            stream.fireToken((IToken)Pipes.renameToken((IToken)token, (String)"li"));
                        }
                    }
                }
            }
        }
    }
}

