/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.texthtml.text.TextTool;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenEmitter;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import de.xam.tokenpipe.pipe.buffer.TokenBuffer;
import de.xam.tokenpipe.pipe.buffer.TwoBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LineTypeTokenPipe
extends AbstractTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(LineTypeTokenPipe.class);
    private TokenBuffer tokenBuffer;
    private TwoBuffer twoBuffer;
    private static final Pattern pattern_HEADLINE = Pattern.compile("([!]{1,6})(.*)");
    private static final Pattern pattern_INDENT = Pattern.compile("([ \\t]+)[^ \\t].*");
    private static final String LIST_ITEM_MARKER_CHARS = "-*+";
    private static final String LIST_ITEM_WHITESPACE_CHARS = " \\t";
    private static final Pattern pattern_LIST_ITEM = Pattern.compile("((([ \\t]+)[-*+]+)|(([-*+]+)[ \\t]+)).*");
    private String lastTokenName = null;
    private Mode mode;
    private final ArrayList<Pair<String, String>> pairs = new ArrayList();

    public static void main(String[] args) {
        System.out.println("rx = " + pattern_LIST_ITEM);
    }

    public String getLabel() {
        return "linetype";
    }

    public String[] consumedTokenTypes() {
        return new String[]{"line", "inline", "pre", "string"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"line", "inline", "pre", "string", "headline", "listItem", "hr"};
    }

    public void onBeforeDocument() {
        this.mode = Mode.LineStart;
        this.tokenBuffer = new TokenBuffer(this.getLabel());
        this.twoBuffer = new TwoBuffer(this.getLabel(), (ITokenEmitter)this.tokenBuffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onToken(ITokenStream stream, IToken token) {
        switch (token.getType()) {
            case "line": {
                switch (token.getKind()) {
                    case Start: {
                        this.mode = Mode.LineStart;
                        break;
                    }
                    case End: {
                        this.fireEndTokenForLastStartToken(stream);
                        break;
                    }
                    case Content: {
                        assert (false);
                        break;
                    }
                }
                break;
            }
        }
        if (token.isContent() && token.getType().equals("inline") && this.mode == Mode.LineStart) {
            this.classifyLine_fireStart_fireContent(stream, token);
            this.mode = Mode.LaterInALine;
            return;
        }
        this.tokenBuffer.fireToken(token);
        if (token.getType().equals("line") && token.isEnd()) {
            this.tokenBuffer.flushTokenBufferAndFireTokens(stream);
        }
    }

    private void classifyLine_fireStart_fireContent(ITokenStream stream, IToken token) {
        String chars = token.getChars();
        Matcher m_indent = pattern_INDENT.matcher(chars);
        Matcher m_listItem = pattern_LIST_ITEM.matcher(chars);
        Matcher m_headline = pattern_HEADLINE.matcher(chars);
        if (m_headline.matches()) {
            int headlineMarkerCount = m_headline.end(1) - m_headline.start(1);
            int level = Math.max(5 - headlineMarkerCount, 2);
            this.lastTokenName = "headline";
            this.pairs.add((Pair<String, String>)new Pair((Object)"headlineLevel", (Object)("" + level)));
            Map<String, String> lineStartTokenContext = LineTypeTokenPipe.getLineStartTokenContext(this.tokenBuffer);
            lineStartTokenContext.put("lineType", "headline");
            this.twoBuffer.lookBack(chars.substring(0, headlineMarkerCount));
            this.twoBuffer.fireLookBackAsStartToBuffer(this.lastTokenName, this.pairs.toArray(new Pair[0]));
            if (headlineMarkerCount < chars.length()) {
                String remain = chars.substring(headlineMarkerCount);
                assert (remain.length() > 0);
                this.twoBuffer.continueCurrentToken(remain);
                this.twoBuffer.fireCurrentContentToBuffer("inline", token.getContextAsPairsAndAdd(new Pair[0]));
            }
        } else if (chars.startsWith("----")) {
            String control = "----";
            this.lastTokenName = null;
            this.twoBuffer.lookBack(chars.substring(0, "----".length()));
            this.twoBuffer.fireLookBackAsStartToBuffer("hr", this.pairs.toArray(new Pair[0]));
            this.twoBuffer.fireLookBackAsEndToBuffer("hr", this.pairs.toArray(new Pair[0]));
            if (chars.length() > "----".length()) {
                String remain = chars.substring("----".length());
                this.twoBuffer.continueCurrentToken(remain);
                this.twoBuffer.fireCurrentContentToBuffer("inline", token.getContextAsPairsAndAdd(new Pair[0]));
            }
        } else if (m_indent.matches()) {
            String control = m_indent.group(1);
            int level = control.length();
            Map<String, String> lineStartTokenContext = LineTypeTokenPipe.getLineStartTokenContext(this.tokenBuffer);
            lineStartTokenContext.put("lineIndent", "" + level);
            if (chars.length() > control.length()) {
                String remain = chars.substring(control.length());
                this.twoBuffer.continueCurrentToken(remain);
                this.twoBuffer.fireCurrentContentToBuffer("inline", token.getContextAsPairsAndAdd(new Pair[]{new Pair((Object)"lineIndent", (Object)("" + level))}));
            }
        } else if (m_listItem.matches()) {
            String control = m_listItem.group(1);
            assert (control != null) : "just matched on '" + chars + "'";
            assert (control.equals(chars.substring(0, control.length())));
            this.lastTokenName = "listItem";
            this.twoBuffer.lookBack(control);
            int listNestingLevel = LineTypeTokenPipe.listNestingLevel(control);
            this.pairs.add((Pair<String, String>)new Pair((Object)"data-listLevel", (Object)("" + listNestingLevel)));
            Map<String, String> lineStartTokenContext = LineTypeTokenPipe.getLineStartTokenContext(this.tokenBuffer);
            lineStartTokenContext.put("lineType", "listItem");
            lineStartTokenContext.put("data-listLevel", "" + listNestingLevel);
            this.twoBuffer.fireLookBackAsStartToBuffer(this.lastTokenName, this.pairs.toArray(new Pair[0]));
            if (chars.length() > control.length()) {
                String remain = chars.substring(control.length());
                this.twoBuffer.continueCurrentToken(remain);
                this.twoBuffer.fireCurrentContentToBuffer("inline", token.getContextAsPairsAndAdd(new Pair[0]));
            }
        } else {
            this.tokenBuffer.fireToken(token);
        }
    }

    private static Map<String, String> getLineStartTokenContext(TokenBuffer tokenBuffer) {
        IToken lineToken = tokenBuffer.getBufferedTokenOfType("line");
        return lineToken.getContextAsMap();
    }

    private static int listNestingLevel(String s) {
        assert (s != null);
        assert (pattern_LIST_ITEM.matcher(s + "AAA").matches()) : "'" + s + "'";
        if (s.length() == 0) {
            return 0;
        }
        if (s.startsWith(" ") || s.startsWith("\t")) {
            return TextTool.countConsecutiveMatches((String)"[ \\t]", (String)s);
        }
        return TextTool.countConsecutiveMatches((String)"[-*+]", (String)s);
    }

    private void fireEndTokenForLastStartToken(ITokenStream stream) {
        if (this.lastTokenName != null) {
            this.twoBuffer.fireLookBackAsEndToBuffer(this.lastTokenName, this.pairs.toArray(new Pair[0]));
            this.lastTokenName = null;
            this.pairs.clear();
        }
    }

    static {
        assert (pattern_LIST_ITEM.matcher("* foo").matches());
        assert (pattern_LIST_ITEM.matcher("* *Hinweise:*").matches());
    }

    static enum Mode {
        LineStart,
        LaterInALine;

    }
}

