/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenEmitter;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import de.xam.tokenpipe.pipe.buffer.TokenBuffer;
import de.xam.tokenpipe.pipe.buffer.TwoBuffer;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KeyValueTokenPipe
extends AbstractTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(KeyValueTokenPipe.class);
    private Mode mode;
    private IToken keyToken;
    private TwoBuffer twoBuffer;
    private TokenBuffer tokenBuffer;

    public String getLabel() {
        return "keyvalue";
    }

    public String[] consumedTokenTypes() {
        return new String[]{"inline", "line"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"inline", "key", "value"};
    }

    public void onBeforeDocument() {
        this.mode = Mode.Key;
        this.tokenBuffer = new TokenBuffer(this.getLabel());
        this.twoBuffer = new TwoBuffer(this.getLabel(), (ITokenEmitter)this.tokenBuffer);
    }

    public void onBeforeContentToken(ITokenStream stream, IToken token) {
        stream.debug("Before. Mode = " + (Object)((Object)this.mode) + " C=" + this.twoBuffer.currentTokenLength() + " L=" + this.twoBuffer.lookBackLenght());
        if (token.getType().equals("line") && token.isEnd()) {
            switch (this.mode) {
                case Key: {
                    break;
                }
                case ValueStart: {
                    if (this.twoBuffer.currentTokenLength() > 0) {
                        this.twoBuffer.fireLookBackAsStartToBuffer("value", new Pair[0]);
                        this.twoBuffer.fireCurrentContentToBuffer("inline", new Pair[0]);
                        this.twoBuffer.fireLookBackAsEndToBuffer("value", new Pair[0]);
                    }
                    this.mode = Mode.ValueContinue;
                    break;
                }
                case ValueContinue: {
                    this.twoBuffer.fireLookBackAsEndToBuffer("value", new Pair[0]);
                    break;
                }
            }
            this.mode = Mode.Key;
            return;
        }
        this.twoBuffer.clearBuffers();
    }

    public void onAfterContentToken(ITokenStream stream, IToken token) {
        stream.debug("After. Mode = " + (Object)((Object)this.mode) + " C=" + this.twoBuffer.currentTokenLength() + " L=" + this.twoBuffer.lookBackLenght());
        if (token.getType().equals("line")) {
            return;
        }
        if (token.getType().equals("inline")) {
            switch (this.mode) {
                case Key: {
                    this.mode = Mode.NoKeyValueOnThisLine;
                    this.tokenBuffer.fireToken(token);
                    break;
                }
                case ValueStart: {
                    if (token == this.keyToken) {
                        if (this.twoBuffer.currentTokenLength() > 0) {
                            this.twoBuffer.fireLookBackAsStartToBuffer("value", new Pair[0]);
                            this.twoBuffer.fireCurrentContentToBuffer("inline", new Pair[0]);
                        }
                    } else {
                        this.twoBuffer.fireLookBackAsStartToBuffer("value", new Pair[0]);
                        this.tokenBuffer.fireToken(token);
                    }
                    this.mode = Mode.ValueContinue;
                    break;
                }
                case ValueContinue: 
                case NoKeyValueOnThisLine: {
                    this.tokenBuffer.fireToken(token);
                }
            }
        }
    }

    public void onContentCodepoint(ITokenStream stream, int c, int i, IToken token) {
        assert (this.mode != null);
        switch (this.mode) {
            case Key: {
                if (c == 58) {
                    this.twoBuffer.fireLookBackAsStartToBuffer("key", new Pair[0]);
                    this.twoBuffer.fireCurrentContentToBuffer("inline", new Pair[0]);
                    this.twoBuffer.lookBack(c);
                    this.twoBuffer.fireLookBackAsEndToBuffer("key", new Pair[0]);
                    this.mode = Mode.ValueStart;
                    this.keyToken = token;
                    break;
                }
                this.twoBuffer.continueCurrentToken(c);
                break;
            }
            case ValueStart: {
                this.twoBuffer.continueCurrentToken(c);
                break;
            }
            case ValueContinue: 
            case NoKeyValueOnThisLine: {
                this.twoBuffer.clearBuffers();
            }
        }
    }

    public void onToken(ITokenStream stream, IToken token) {
        if (token.getType().equals("document") && token.isEnd()) {
            this.tokenBuffer.flushTokenBufferAndFireTokens(stream);
        }
    }

    static enum Mode {
        Key,
        ValueStart,
        ValueContinue,
        NoKeyValueOnThisLine;

    }
}

