/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.Pipes;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import java.util.Stack;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class HtmlEmphPipe
extends AbstractTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(HtmlEmphPipe.class);
    private int currentEmphLevel;
    private Stack<IToken> openEmphs;

    public String[] consumedTokenTypes() {
        return new String[]{"emph", "document"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"em", "strong", "document"};
    }

    public String getLabel() {
        return "htmlEmph";
    }

    public void onBeforeDocument() {
        this.currentEmphLevel = 0;
        this.openEmphs = new Stack();
    }

    public void onAfterDocument() {
        assert (this.currentEmphLevel == 0) : "currentEmphLevel=" + this.currentEmphLevel;
    }

    public void onToken(ITokenStream stream, IToken token) {
        if (token.getType().equals("document")) {
            if (token.isEnd()) {
                if (this.currentEmphLevel > 0) {
                    assert (!this.openEmphs.isEmpty());
                    this.closeAllOpenTags(stream);
                }
                assert (this.currentEmphLevel == 0);
            }
            stream.fireToken(token);
        } else {
            assert (token.getType().equals("emph"));
            int emphDelta = token.getContextAsInt("emphDelta");
            assert (emphDelta >= -3) : "emphDelta=" + emphDelta;
            assert (emphDelta <= 3) : "emphDelta=" + emphDelta;
            int emphLevel = token.getContextAsInt("emphLevel");
            assert (emphLevel >= 0);
            assert (emphLevel <= 3);
            this.realizeDeltaEmph(stream, token, emphDelta, emphLevel);
        }
    }

    private void closeAllOpenTags(ITokenStream stream) {
        while (!this.openEmphs.isEmpty()) {
            this.closeLastOpenenedTag(stream);
        }
    }

    private int closeLastOpenenedTag(ITokenStream stream) {
        IToken t = this.openEmphs.pop();
        assert (t.getType() == "em" || t.getType() == "strong");
        IToken endToken = Pipes.endToken((IToken)t, (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"ot-1")});
        stream.fireToken(endToken);
        int delta = t.getType() == "em" ? -1 : -2;
        this.currentEmphLevel += delta;
        return delta;
    }

    private void realizeDeltaEmph(ITokenStream stream, IToken token, int deltaEmph, int emphLevel) {
        int remainingDeltaEmph;
        assert (deltaEmph >= -3) : "deltaEmph=" + deltaEmph;
        assert (deltaEmph <= 3) : "deltaEmph=" + deltaEmph;
        assert (emphLevel >= 0);
        assert (emphLevel <= 3);
        if (deltaEmph > 0) {
            switch (deltaEmph) {
                case 1: {
                    IToken t1 = Pipes.startToken((String)"em", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"ot-1")});
                    this.openEmphs.push(t1);
                    stream.fireToken(t1);
                    ++this.currentEmphLevel;
                    break;
                }
                case 2: {
                    IToken t1 = Pipes.startToken((String)"strong", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"ot-1")});
                    this.openEmphs.push(t1);
                    stream.fireToken(t1);
                    this.currentEmphLevel += 2;
                    break;
                }
                case 3: {
                    IToken t1 = Pipes.startToken((String)"em", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"ot-1")});
                    this.openEmphs.push(t1);
                    stream.fireToken(t1);
                    IToken t2 = Pipes.startToken((String)"strong", (Pair[])new Pair[]{new Pair((Object)"trace", (Object)"ot-1")});
                    this.openEmphs.push(t2);
                    stream.fireToken(t2);
                    this.currentEmphLevel += 3;
                }
            }
        }
        for (remainingDeltaEmph = deltaEmph; remainingDeltaEmph < 0 && !this.openEmphs.isEmpty(); remainingDeltaEmph -= this.closeLastOpenenedTag(stream)) {
        }
        if (remainingDeltaEmph < 0) {
            assert (this.openEmphs.isEmpty());
            throw new AssertionError((Object)("Could not de-emph (remainingDeltaEmph=" + remainingDeltaEmph + ",emphLevel=" + emphLevel + ") token=" + token));
        }
    }
}

