/*
 * Decompiled with CFR 0.152.
 */
package de.xam.htmlwidgets.parts;

import com.google.common.base.Joiner;
import de.xam.htmlwidgets.ToHtml;
import de.xam.htmlwidgets.parts.Attribute;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class Element<T extends Element<T>>
implements ToHtml {
    protected String tag;
    protected boolean first;
    protected SortedMap<String, Attribute> attributes = new TreeMap<String, Attribute>();
    protected ToHtml parent = null;
    private SortedSet<String> cssClasses;

    public Element(ToHtml parent, String tag, Attribute ... attributes) {
        this.tag = tag;
        if (attributes != null) {
            for (Attribute att : attributes) {
                this.addAttribute(att);
            }
        }
    }

    public T cssClasses(String ... cssClasses) {
        this.cssClasses = new TreeSet<String>();
        for (String c : cssClasses) {
            this.cssClasses.add(c);
        }
        StringBuilder b = new StringBuilder();
        Joiner.on((String)" ").appendTo(b, (Object[])cssClasses);
        Attribute att = (Attribute)this.attributes.get("class");
        if (att == null) {
            Attribute a = new Attribute("class", b.toString());
            this.attributes.put(a.name, a);
        } else {
            att.value = att.value + " " + b.toString();
        }
        return (T)this;
    }

    public T addAttribute(String name, String value) {
        Attribute att = new Attribute(name, value);
        this.addAttribute(att);
        return (T)this;
    }

    public T addAttribute(Attribute att) {
        this.attributes.put(att.name, att);
        return (T)this;
    }

    public String toString() {
        return this.toHtml("");
    }
}

