/*
 * Decompiled with CFR 0.152.
 */
package de.xam.htmlwidgets;

import de.xam.htmlwidgets.ToHtml;
import de.xam.htmlwidgets.elements.Paragraph;
import de.xam.htmlwidgets.elements.form.Form;
import de.xam.htmlwidgets.page.Head;
import de.xam.htmlwidgets.page.Html;
import de.xam.htmlwidgets.parts.Attribute;
import de.xam.htmlwidgets.parts.HtmlNode;
import java.util.List;

public class Page {
    public static final ToHtml BR = new HtmlNode("<br />");

    public static Head htmlHeadTitle(String title) {
        Html html = new Html();
        Head head = html.head();
        head.title(title);
        return head;
    }

    public static void main(String[] args) {
        Paragraph p = Page.htmlHeadTitle("Hello World").endHeadStartBody().paragraph("Foo");
        Form form = p.form(Form.METHOD.GET, "/my/url");
        form.inputText("Name: ", "name", "John Doe");
        form.inputSubmit("Abschicken");
        String s2 = p.endBodyEndHtml().toString();
        System.out.println(s2);
        Form form2 = new Form(null, Form.METHOD.GET, "/my/url");
        form2.inputText("Name: ", "name", "John Doe");
        form2.inputSubmit("Abschicken");
        String s3 = form2.toHtml("  ");
        System.out.println(s3);
    }

    public static String renderToHtml(String indent, boolean first, RenderMode renderMode, String tag, String content, Attribute ... attributes) {
        StringBuffer buf = new StringBuffer();
        if (!first && renderMode != RenderMode.Inline) {
            buf.append("\n");
        }
        if (renderMode == RenderMode.Block || renderMode == RenderMode.InlineBlock) {
            buf.append(indent);
        }
        buf.append("<").append(tag).append(Page.toHtmlAttributes(attributes));
        if (content == null || content.equals("")) {
            buf.append(">");
            buf.append("</").append(tag).append(">");
        } else {
            buf.append(">");
            buf.append(content);
            if (renderMode == RenderMode.Block) {
                buf.append("\n");
                buf.append(indent);
            }
            buf.append("</").append(tag).append(">");
        }
        return buf.toString();
    }

    public static String toHtml(String indent, List<ToHtml> children) {
        StringBuffer buf = new StringBuffer();
        for (ToHtml child : children) {
            buf.append(child.toHtml(indent));
        }
        return buf.toString();
    }

    private static String toHtmlAttributes(Attribute ... attributes) {
        StringBuffer buf = new StringBuffer();
        for (Attribute attribute : attributes) {
            if (attribute.getValue() == null) continue;
            buf.append(attribute.toHtml());
        }
        return buf.toString();
    }

    public static enum RenderMode {
        Block,
        Inline,
        InlineBlock;

    }
}

