/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;

public class TestScope {
    public static final Singleton SINGLETON = new Singleton("TestSingleton");
    public static final Singleton EAGER_SINGLETON = new Singleton("EagerTestSingleton");

    public static void clear() {
        SINGLETON.clear();
        EAGER_SINGLETON.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Singleton
    implements Scope {
        private final String simpleName;
        private final Map<Key<?>, Object> backingMap = new HashMap();

        public Singleton(String simpleName) {
            this.simpleName = simpleName;
        }

        public void clear() {
            this.backingMap.clear();
        }

        public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
            return new Provider<T>(){

                public T get() {
                    Object o = Singleton.this.backingMap.get(key);
                    if (o == null) {
                        o = unscoped.get();
                        Singleton.this.backingMap.put(key, o);
                    }
                    return o;
                }
            };
        }

        public String toString() {
            return this.simpleName;
        }
    }
}

