/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.jukito.JukitoInternal;
import org.jukito.MockProvider;
import org.jukito.SpyProvider;
import org.jukito.TestEagerSingleton;
import org.jukito.TestScope;
import org.jukito.TestSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestModule
extends AbstractModule {
    protected Class<?> testClass;

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    public void configure() {
        this.bindScopes();
        this.configureTest();
    }

    protected void bindScopes() {
        this.bindScope(TestSingleton.class, TestScope.SINGLETON);
        this.bindScope(TestEagerSingleton.class, TestScope.EAGER_SINGLETON);
    }

    protected abstract void configureTest();

    protected <T> ScopedBindingBuilder bindMock(Class<T> klass) {
        return this.bindNewMockProvider(Key.get(klass));
    }

    protected <T> ScopedBindingBuilder bindMock(TypeLiteral<T> typeLiteral) {
        return this.bindNewMockProvider(Key.get(typeLiteral));
    }

    protected <T> ScopedBindingBuilder bindSpy(Class<T> klass) {
        return this.bindNewSpyProvider(Key.get(klass));
    }

    protected <T> ScopedBindingBuilder bindSpy(TypeLiteral<T> typeLiteral) {
        return this.bindNewSpyProvider(Key.get(typeLiteral));
    }

    protected <T> ScopedBindingBuilder bindNamedMock(Class<T> klass, String name) {
        return this.bindNewMockProvider(Key.get(klass, (Annotation)Names.named((String)name)));
    }

    protected <T> ScopedBindingBuilder bindNamedMock(TypeLiteral<T> typeLiteral, String name) {
        return this.bindNewMockProvider(Key.get(typeLiteral, (Annotation)Names.named((String)name)));
    }

    protected <T> ScopedBindingBuilder bindNamedSpy(Class<T> klass, String name) {
        return this.bindNewSpyProvider(Key.get(klass, (Annotation)Names.named((String)name)));
    }

    protected <T> ScopedBindingBuilder bindNamedSpy(TypeLiteral<T> typeLiteral, String name) {
        return this.bindNewSpyProvider(Key.get(typeLiteral, (Annotation)Names.named((String)name)));
    }

    private <T> ScopedBindingBuilder bindNewMockProvider(Key<T> key) {
        return this.bind(key).toProvider(new MockProvider(key.getTypeLiteral().getRawType()));
    }

    private <T> ScopedBindingBuilder bindNewSpyProvider(Key<T> key) {
        TypeLiteral type = key.getTypeLiteral();
        InjectionPoint constructorInjectionPoint = InjectionPoint.forConstructorOf((TypeLiteral)type);
        Key relayingKey = Key.get((TypeLiteral)type, JukitoInternal.class);
        this.bind(relayingKey).toConstructor((Constructor)constructorInjectionPoint.getMember());
        return this.bind(key).toProvider(new SpyProvider(this.getProvider(relayingKey), relayingKey));
    }

    protected <T, V extends T> void bindManyInstances(Class<T> clazz, V ... instances) {
        for (V instance : instances) {
            this.bind(clazz).annotatedWith(UniqueAnnotations.create()).toInstance(instance);
        }
    }

    protected <T, V extends T> void bindManyInstances(TypeLiteral<T> type, V ... instances) {
        for (V instance : instances) {
            this.bind(type).annotatedWith(UniqueAnnotations.create()).toInstance(instance);
        }
    }

    protected <T> void bindMany(Class<T> clazz, Class<? extends T> ... boundClasses) {
        for (Class<? extends T> boundClass : boundClasses) {
            this.bind(clazz).annotatedWith(UniqueAnnotations.create()).to(boundClass).in((Scope)TestScope.SINGLETON);
        }
    }

    protected <T, V extends T> void bindMany(TypeLiteral<T> type, TypeLiteral<? extends T> ... boundTypes) {
        for (TypeLiteral<? extends T> boundType : boundTypes) {
            this.bind(type).annotatedWith(UniqueAnnotations.create()).to(boundType).in((Scope)TestScope.SINGLETON);
        }
    }

    protected <T> LinkedBindingBuilder<T> bindNamed(Class<T> klass, String name) {
        return this.bind(klass).annotatedWith((Annotation)Names.named((String)name));
    }

    protected <T> LinkedBindingBuilder<T> bindNamed(TypeLiteral<T> typeLiteral, String name) {
        return this.bind(typeLiteral).annotatedWith((Annotation)Names.named((String)name));
    }
}

