/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.internal.Errors;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jukito.All;
import org.jukito.BindingsCollector;
import org.jukito.GuiceUtils;
import org.jukito.InjectedAfterStatements;
import org.jukito.InjectedBeforeStatements;
import org.jukito.InjectedFrameworkMethod;
import org.jukito.InjectedStatement;
import org.jukito.JukitoModule;
import org.jukito.TestModule;
import org.jukito.TestScope;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.mockito.internal.runners.util.FrameworkUsageValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JukitoRunner
extends BlockJUnit4ClassRunner {
    private static final boolean useAutomockingIfNoEnvironmentFound = true;
    private Injector injector;

    public JukitoRunner(Class<?> klass) throws InitializationError, InvocationTargetException, InstantiationException, IllegalAccessException {
        super(klass);
        this.ensureInjector();
    }

    private void ensureInjector() throws InstantiationException, IllegalAccessException {
        BindingsCollector collector;
        TestModule testModuleForCollection;
        TestModule testModule;
        Class testClass = this.getTestClass().getJavaClass();
        if (this.injector != null) {
            return;
        }
        Class<?> testModuleClass = null;
        JukitoModule jukitoModule = null;
        for (Class<?> subclass : testClass.getDeclaredClasses()) {
            if (!TestModule.class.isAssignableFrom(subclass)) continue;
            assert (testModuleClass == null) : "More than one TestModule inner class found within test class \"" + testClass.getName() + "\".";
            testModuleClass = subclass;
        }
        if (testModuleClass == null) {
            testModule = new JukitoModule(){

                protected void configureTest() {
                }
            };
            testModuleForCollection = new JukitoModule(){

                protected void configureTest() {
                }
            };
        } else {
            testModule = (TestModule)((Object)testModuleClass.newInstance());
            testModuleForCollection = (TestModule)((Object)testModuleClass.newInstance());
        }
        testModule.setTestClass(testClass);
        if (testModule instanceof JukitoModule) {
            jukitoModule = (JukitoModule)testModule;
            collector = new BindingsCollector(testModuleForCollection);
            collector.collectBindings();
            jukitoModule.setBindingsObserved(collector.getBindingsObserved());
        }
        this.injector = Guice.createInjector((Module[])new Module[]{testModule});
        if (jukitoModule != null && jukitoModule.getReportWriter() != null) {
            collector = new BindingsCollector(jukitoModule);
            collector.collectBindings();
            jukitoModule.printReport(collector.getBindingsObserved());
        }
    }

    public void run(RunNotifier notifier) {
        notifier.addListener((RunListener)new FrameworkUsageValidator(notifier));
        super.run(notifier);
    }

    protected Object createTest() throws Exception {
        TestScope.clear();
        this.instantiateEagerTestSingletons();
        return this.injector.getInstance(this.getTestClass().getJavaClass());
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new InjectedStatement(method, test, this.injector);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        try {
            this.ensureInjector();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new InjectedBeforeStatements(statement, befores, target, this.injector);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        try {
            this.ensureInjector();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new InjectedAfterStatements(statement, afters, target, this.injector);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        try {
            this.ensureInjector();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>(testMethods.size());
        for (FrameworkMethod method : testMethods) {
            Method javaMethod = method.getMethod();
            Errors errors = new Errors((Object)javaMethod);
            List<Key<?>> keys = GuiceUtils.getMethodKeys(javaMethod, errors);
            errors.throwConfigurationExceptionIfErrorsExist();
            ArrayList bindingsToUseForParameters = new ArrayList();
            for (Key<?> key : keys) {
                if (!All.class.equals((Object)key.getAnnotationType())) continue;
                ArrayList<Binding> bindings = new ArrayList<Binding>();
                for (Binding binding : this.injector.findBindingsByType(key.getTypeLiteral())) {
                    bindings.add(binding);
                }
                bindingsToUseForParameters.add(bindings);
            }
            this.addAllBindingAssignations(bindingsToUseForParameters, 0, new ArrayList(bindingsToUseForParameters.size()), javaMethod, result);
        }
        return result;
    }

    private void addAllBindingAssignations(List<List<Binding<?>>> bindingsToUseForParameters, int index, List<Binding<?>> currentAssignation, Method javaMethod, List<FrameworkMethod> result) {
        if (index >= bindingsToUseForParameters.size()) {
            ArrayList assignation = new ArrayList(currentAssignation.size());
            assignation.addAll(currentAssignation);
            result.add(new InjectedFrameworkMethod(javaMethod, assignation));
            return;
        }
        for (Binding<?> binding : bindingsToUseForParameters.get(index)) {
            currentAssignation.add(binding);
            if (currentAssignation.size() != index + 1) {
                throw new AssertionError((Object)"Size of currentAssignation list is wrong.");
            }
            this.addAllBindingAssignations(bindingsToUseForParameters, index + 1, currentAssignation, javaMethod, result);
            currentAssignation.remove(index);
        }
    }

    private void instantiateEagerTestSingletons() {
        DefaultBindingScopingVisitor<Boolean> isEagerTestScopeSingleton = new DefaultBindingScopingVisitor<Boolean>(){

            public Boolean visitScope(Scope scope) {
                return scope == TestScope.EAGER_SINGLETON;
            }
        };
        for (Binding binding : this.injector.getBindings().values()) {
            Boolean result;
            boolean instantiate = false;
            if (binding != null && (result = (Boolean)binding.acceptScopingVisitor((BindingScopingVisitor)isEagerTestScopeSingleton)) != null && result.booleanValue()) {
                instantiate = true;
            }
            if (!instantiate) continue;
            binding.getProvider().get();
        }
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidMethods(After.class, false, errors);
        this.validatePublicVoidMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (this.computeTestMethods().size() == 0) {
            errors.add(new Exception("No runnable methods"));
        }
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidMethods(Test.class, false, errors);
    }

    protected void validatePublicVoidMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected Injector getInjector() {
        return this.injector;
    }
}

