/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.internal.Errors;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jukito.All;
import org.jukito.BindingsCollector;
import org.jukito.GuiceUtils;
import org.jukito.MockProvider;
import org.jukito.TestModule;
import org.jukito.TestScope;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JukitoModule
extends TestModule {
    protected List<BindingsCollector.BindingInfo> bindingsObserved = Collections.emptyList();
    private final Set<Class<?>> forceMock = new HashSet();
    private final Set<Class<?>> dontForceMock = new HashSet();
    private final List<Key<?>> keysNeedingTransitiveDependencies = new ArrayList();
    private final Map<Class<?>, Object> primitiveTypes = new HashMap();

    public JukitoModule() {
        this.primitiveTypes.put(String.class, "");
        this.primitiveTypes.put(Integer.class, 0);
        this.primitiveTypes.put(Long.class, 0L);
        this.primitiveTypes.put(Boolean.class, false);
        this.primitiveTypes.put(Double.class, 0.0);
        this.primitiveTypes.put(Float.class, Float.valueOf(0.0f));
        this.primitiveTypes.put(Short.class, (short)0);
        this.primitiveTypes.put(Character.class, Character.valueOf('\u0000'));
        this.primitiveTypes.put(Byte.class, (byte)0);
        this.primitiveTypes.put(Class.class, Object.class);
    }

    public void setBindingsObserved(List<BindingsCollector.BindingInfo> bindingsObserved) {
        this.bindingsObserved = bindingsObserved;
    }

    protected void forceMock(Class<?> klass) {
        this.forceMock.add(klass);
    }

    @Override
    public final void configure() {
        this.bindScopes();
        this.configureTest();
        HashSet keysObserved = new HashSet(this.bindingsObserved.size());
        HashSet keysNeeded = new HashSet(this.bindingsObserved.size());
        for (BindingsCollector.BindingInfo bindingInfo : this.bindingsObserved) {
            if (bindingInfo.key != null) {
                keysObserved.add(bindingInfo.key);
            }
            if (bindingInfo.boundKey != null) {
                keysNeeded.add(bindingInfo.boundKey);
            }
            if (bindingInfo.boundInstance == null || !(bindingInfo.boundInstance instanceof HasDependencies)) continue;
            HasDependencies hasDependencies = (HasDependencies)bindingInfo.boundInstance;
            for (Dependency dependency : hasDependencies.getDependencies()) {
                keysNeeded.add(dependency.getKey());
            }
        }
        for (Key key : keysNeeded) {
            this.addNeededKey(keysObserved, keysNeeded, key, false);
            this.keysNeedingTransitiveDependencies.add(key);
        }
        for (Class currentClass = this.testClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Test.class) && !method.isAnnotationPresent(Before.class) && !method.isAnnotationPresent(After.class)) continue;
                Errors errors = new Errors((Object)method);
                List<Key<?>> keys = GuiceUtils.getMethodKeys(method, errors);
                for (Key<?> key : keys) {
                    if (All.class.equals((Object)key.getAnnotationType())) continue;
                    Key<?> keyNeeded = GuiceUtils.ensureProvidedKey(key, errors);
                    this.addNeededKey(keysObserved, keysNeeded, keyNeeded, true);
                }
                errors.throwConfigurationExceptionIfErrorsExist();
            }
        }
        Set set = InjectionPoint.forInstanceMethodsAndFields((Class)this.testClass);
        for (InjectionPoint injectionPoint : set) {
            Errors errors = new Errors((Object)injectionPoint);
            List dependencies = injectionPoint.getDependencies();
            for (Dependency dependency : dependencies) {
                Key keyNeeded = GuiceUtils.ensureProvidedKey(dependency.getKey(), errors);
                this.addNeededKey(keysObserved, keysNeeded, keyNeeded, true);
            }
            errors.throwConfigurationExceptionIfErrorsExist();
        }
        for (int i = 0; i < this.keysNeedingTransitiveDependencies.size(); ++i) {
            this.addDependencies(this.keysNeedingTransitiveDependencies.get(i), keysObserved, keysNeeded);
        }
        for (Key key : keysNeeded) {
            Class rawType = key.getTypeLiteral().getRawType();
            if (keysObserved.contains(key) || this.isCoreGuiceType(rawType) || this.isAssistedInjection(key)) continue;
            Object primitiveInstance = this.getDummyInstanceOfPrimitiveType(rawType);
            if (primitiveInstance == null) {
                this.bind(key).toProvider(new MockProvider(rawType)).in((Scope)TestScope.SINGLETON);
                continue;
            }
            this.bindKeyToInstance(key, primitiveInstance);
        }
    }

    private <T> void bindKeyToInstance(Key<T> key, Object primitiveInstance) {
        this.bind(key).toInstance(primitiveInstance);
    }

    private void addNeededKey(Set<Key<?>> keysObserved, Set<Key<?>> keysNeeded, Key<?> keyNeeded, boolean asTestSingleton) {
        keysNeeded.add(keyNeeded);
        this.bindIfConcrete(keysObserved, keyNeeded, asTestSingleton);
    }

    private <T> void bindIfConcrete(Set<Key<?>> keysObserved, Key<T> key, boolean asTestSingleton) {
        TypeLiteral typeToBind = key.getTypeLiteral();
        Class rawType = typeToBind.getRawType();
        if (!keysObserved.contains(key) && this.canBeInjected(typeToBind) && !this.shouldForceMock(rawType) && !this.isAssistedInjection(key)) {
            if (asTestSingleton || rawType.getAnnotation(Singleton.class) != null) {
                this.bind(key).in((Scope)TestScope.SINGLETON);
            } else {
                this.bind(key);
            }
            keysObserved.add(key);
            this.keysNeedingTransitiveDependencies.add(key);
        }
    }

    private boolean canBeInjected(TypeLiteral<?> type) {
        Class rawType = type.getRawType();
        if (this.isPrimitive(rawType) || this.isCoreGuiceType(rawType) || !this.isInstantiable(rawType)) {
            return false;
        }
        try {
            InjectionPoint.forConstructorOf(type);
            return true;
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    private boolean isAssistedInjection(Key<?> key) {
        return key.getAnnotationType() != null && Assisted.class.isAssignableFrom(key.getAnnotationType());
    }

    private boolean shouldForceMock(Class<?> klass) {
        if (this.dontForceMock.contains(klass)) {
            return false;
        }
        if (this.forceMock.contains(klass)) {
            return true;
        }
        boolean result = false;
        for (Class<?> classToMock : this.forceMock) {
            if (!classToMock.isAssignableFrom(klass)) continue;
            result = true;
            break;
        }
        if (result) {
            this.forceMock.add(klass);
        } else {
            this.dontForceMock.add(klass);
        }
        return result;
    }

    private boolean isInstantiable(Class<?> klass) {
        return !klass.isInterface() && !Modifier.isAbstract(klass.getModifiers());
    }

    private boolean isPrimitive(Class<?> klass) {
        return this.getDummyInstanceOfPrimitiveType(klass) != null;
    }

    private Object getDummyInstanceOfPrimitiveType(Class<?> klass) {
        Object instance = this.primitiveTypes.get(klass);
        if (instance == null && Enum.class.isAssignableFrom(klass)) {
            try {
                instance = ((Object[])klass.getMethod("values", new Class[0]).invoke(null, new Object[0]))[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    private boolean isCoreGuiceType(Class<?> klass) {
        return TypeLiteral.class.isAssignableFrom(klass) || Injector.class.isAssignableFrom(klass) || Logger.class.isAssignableFrom(klass) || Stage.class.isAssignableFrom(klass) || MembersInjector.class.isAssignableFrom(klass);
    }

    private <T> void addDependencies(Key<T> key, Set<Key<?>> keysObserved, Set<Key<?>> keysNeeded) {
        TypeLiteral type = key.getTypeLiteral();
        if (!this.canBeInjected(type)) {
            return;
        }
        this.addInjectionPointDependencies(InjectionPoint.forConstructorOf((TypeLiteral)type), keysObserved, keysNeeded);
        Set methodsAndFieldsInjectionPoints = InjectionPoint.forInstanceMethodsAndFields((TypeLiteral)type);
        for (InjectionPoint injectionPoint : methodsAndFieldsInjectionPoints) {
            this.addInjectionPointDependencies(injectionPoint, keysObserved, keysNeeded);
        }
    }

    private void addInjectionPointDependencies(InjectionPoint injectionPoint, Set<Key<?>> keysObserved, Set<Key<?>> keysNeeded) {
        if (injectionPoint.isOptional()) {
            return;
        }
        for (Dependency dependency : injectionPoint.getDependencies()) {
            Key key = dependency.getKey();
            this.addKeyDependency(key, keysObserved, keysNeeded);
        }
    }

    private void addKeyDependency(Key<?> key, Set<Key<?>> keysObserved, Set<Key<?>> keysNeeded) {
        Key newKey = key;
        if (Provider.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
            Type providedType = ((ParameterizedType)key.getTypeLiteral().getType()).getActualTypeArguments()[0];
            newKey = key.getAnnotation() != null ? Key.get((Type)providedType, (Annotation)key.getAnnotation()) : (key.getAnnotationType() != null ? Key.get((Type)providedType, (Class)key.getAnnotationType()) : Key.get((Type)providedType));
        }
        this.addNeededKey(keysObserved, keysNeeded, newKey, true);
    }

    public Writer getReportWriter() {
        return null;
    }

    public void printReport(List<BindingsCollector.BindingInfo> allBindings) {
        Writer reportWriter = this.getReportWriter();
        if (reportWriter == null) {
            return;
        }
        try {
            reportWriter.append("*** EXPLICIT BINDINGS ***\n");
            Set<Key<?>> reportedKeys = this.outputBindings(reportWriter, this.bindingsObserved, Collections.<Key<?>>emptySet());
            reportWriter.append('\n');
            reportWriter.append("*** AUTOMATIC BINDINGS ***\n");
            this.outputBindings(reportWriter, allBindings, reportedKeys);
            reportWriter.append('\n');
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Set<Key<?>> outputBindings(Writer reportWriter, List<BindingsCollector.BindingInfo> bindings, Set<Key<?>> keysToSkip) throws IOException {
        HashSet reportedKeys = new HashSet(bindings.size());
        for (BindingsCollector.BindingInfo bindingInfo : bindings) {
            if (keysToSkip.contains(bindingInfo.key)) continue;
            reportedKeys.add(bindingInfo.key);
            reportWriter.append("  ");
            reportWriter.append(bindingInfo.key.toString());
            reportWriter.append(" --> ");
            if (bindingInfo.boundKey != null) {
                if (bindingInfo.key == bindingInfo.boundKey) {
                    reportWriter.append("Bound directly");
                } else {
                    reportWriter.append(bindingInfo.boundKey.toString());
                }
            } else if (bindingInfo.boundInstance != null) {
                reportWriter.append("Instance of " + bindingInfo.boundInstance.getClass().getCanonicalName());
            } else {
                reportWriter.append("NOTHING!?");
            }
            reportWriter.append(" ### ");
            if (bindingInfo.scope == null) {
                reportWriter.append("No scope");
            } else {
                reportWriter.append("In scope ");
                reportWriter.append(bindingInfo.scope);
            }
            reportWriter.append('\n');
        }
        return reportedKeys;
    }
}

