/*
 * Decompiled with CFR 0.152.
 */
package de.xam.ksource;

import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.ksource.ISource;
import de.xam.ksource.ISourceItem;
import de.xam.ksource.VocabularySources;
import de.xam.mybase.model.names.IdManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.common.NanoClock;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KSources {
    public static final String NAMESPACE_PREFIX_SOURCE = "source";
    private static final Logger log = LoggerFactory.getLogger(KSources.class);
    public static List<ISource> SOURCES = new ArrayList<ISource>();

    public static XId getSourceId(ISource source) {
        return IdManager.toFastRawId((String)("source-" + source.getPrefix()));
    }

    public static void persists(File targetDir) {
        assert (targetDir != null);
        assert (targetDir.exists());
        assert (targetDir.isDirectory());
    }

    public static void startSources() {
        for (ISource source : SOURCES) {
            if (!source.getServiceState().mayStart()) continue;
            try {
                source.start();
            }
            catch (Exception e) {
                log.warn("Exception in source " + source.getPrefix(), (Throwable)e);
                throw new RuntimeException(e);
            }
            while (source.getServiceState().isStarting()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void refreshSource(ISource source, IItemSet itemSet) throws IOException {
        log.info("Refreshing source " + source.getPrefix());
        NanoClock clock = new NanoClock();
        clock.start();
        XId sourceId = KSources.getSourceId(source);
        IItem sourceItem = itemSet.getItemById(sourceId);
        assert (sourceItem != null) : "no source item with id '" + sourceId + "'";
        clock.stopAndStart("add-metadata");
        Iterator it = source.iterator();
        int count = 0;
        while (it.hasNext() && !source.getServiceState().shouldStop()) {
            ISourceItem si = (ISourceItem)it.next();
            si.readDataToMyBase(itemSet);
            if (++count % 100 != 0 && it.hasNext()) continue;
            String stats = "Indexed " + count + " items; last was '" + si.getLocalStringId() + "'";
            sourceItem.setAttribute(VocabularySources.ATTRIBUTE_SOURCE_INDEX_STATS, (XValue)XV.toValue((String)stats));
            log.info("Refreshed " + count + " items in " + source.getPrefix());
        }
        clock.stopAndStart("index-all-sourceitems");
        log.info("done indexing source '" + source.getPrefix() + "'; stats=" + clock.getStats());
    }

    public static void stopAllSources() {
        for (ISource source : SOURCES) {
            source.stop();
        }
    }

    public static void waitUntilAllStopped() {
        boolean someAreActive = true;
        while (someAreActive) {
            someAreActive = false;
            for (ISource source : SOURCES) {
                if (!source.getServiceState().isActive()) continue;
                someAreActive = true;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void stop(String prefix) {
        ISource source = KSources.getSourceByPrefix(prefix);
        if (source != null) {
            source.stop();
        }
    }

    public static ISource getSourceByPrefix(String prefix) {
        for (ISource source : SOURCES) {
            if (!source.getPrefix().equals(prefix)) continue;
            return source;
        }
        return null;
    }

    public static void start(String prefix) throws IOException {
        ISource source = KSources.getSourceByPrefix(prefix);
        if (source != null) {
            source.start();
        }
    }

    public static void addBuiltIns(IItemSet myBase) {
        for (ISource source : SOURCES) {
            source.addBuiltIns(myBase);
            assert (myBase.getItemById(KSources.getSourceId(source)) != null);
        }
    }

    public static Collection<ISource> sources() {
        return SOURCES;
    }

    public static void registerSource(ISource source) {
        SOURCES.add(source);
    }
}

