/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tupleinf.impl;

import de.xam.tupleinf.IInverseTransitiveTupleIndex;
import de.xam.tupleinf.InfLayerRead;
import java.util.Iterator;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.index.query.Wildcard;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.DebugUtils;

public abstract class ITTI_Base<T>
implements IInverseTransitiveTupleIndex<T> {
    private static final Logger log = LoggerFactory.getLogger(ITTI_Base.class);
    protected static final ITransformer TUPLE_INVERTER = new ITransformer<KeyEntryTuple, KeyEntryTuple>(){

        public KeyEntryTuple transform(KeyEntryTuple t) {
            return new KeyEntryTuple(t.getSecond(), t.getFirst());
        }
    };
    protected final Constraint<T> ANY = new Wildcard();
    private final boolean concurrent;
    protected boolean effectiveSymmetric;
    protected boolean effectiveTransitive;
    protected boolean flagSymmetric;
    protected boolean flagTransitive;
    private ITTI_Base<T> inverseIndex;
    protected boolean isDirtyInf = false;
    private boolean isPrimary;
    protected final T p;

    protected static <T> Iterator<KeyEntryTuple<T, T>> invert(Iterator<KeyEntryTuple<T, T>> it) {
        return Iterators.transform(it, (ITransformer)TUPLE_INVERTER);
    }

    public ITTI_Base(T p, boolean concurrent) {
        this.p = p;
        this.concurrent = concurrent;
        this.effectiveSymmetric = false;
        this.effectiveTransitive = false;
        this.flagSymmetric = false;
        this.flagTransitive = false;
        this.inverseIndex = null;
        this.isDirtyInf = false;
        this.isPrimary = true;
    }

    protected final void checkAssertions() {
        if (this.effectiveSymmetric) {
            assert (this.isPrimary);
            assert (this.inverseIndex == null);
        }
        if (this.inverseIndex != null) assert (!this.effectiveSymmetric);
        if (this.effectiveTransitive && this.inverseIndex != null) {
            this.inverseIndex.isTransitive();
        }
        if (this.isPrimary && this.inverseIndex != null) assert (!this.inverseIndex.isPrimary);
        if (!this.isPrimary) assert (this.inverseIndex != null) : "a secondary index always has an inverse";
    }

    @Override
    public final void clearInf() {
        if (this.isSecondary()) {
            ((ITTI_Base)this.getInverseIndex()).primary__clearInf();
        } else {
            this.primary__clearInf();
        }
    }

    @Override
    public final boolean contains(Constraint<T> cA, Constraint<T> cB, InfLayerRead infLayer) {
        if (log.isDebugEnabled()) {
            log.debug("Tuplequery " + this.p + ".(" + cA + "," + cB + ")");
        }
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).primary__contains((T)cB, (T)cA, infLayer);
        }
        return this.primary__contains((T)cA, (T)cB, infLayer);
    }

    @Override
    public final boolean contains(T a, T b, InfLayerRead infLayer) {
        if (log.isDebugEnabled()) {
            log.debug("Tuplequery " + this.p + ".(" + a + "," + b + ")");
        }
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).primary__contains(b, a, infLayer);
        }
        return this.primary__contains(a, b, infLayer);
    }

    @Override
    public final boolean deIndex(T a, T b) {
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).primary__deIndex(b, a);
        }
        return this.primary__deIndex(a, b);
    }

    protected abstract void do__clearBase();

    protected abstract void do__clearInfd();

    protected abstract void do__contentToString(StringBuilder var1);

    protected final void do__dump() {
        log.info(this.do__metaDataToString());
        this.do__dumpContent();
    }

    protected abstract void do__dumpContent();

    protected final void do__markInferenceAsComplete() {
        this.isDirtyInf = false;
    }

    protected final void do__markInferenceAsDirty() {
        this.isDirtyInf = true;
    }

    protected final String do__metaDataToString() {
        return "p='" + this.getP() + "' -> " + "inv=" + (this.hasInverse() ? "'" + ((ITTI_Base)this.getInverseIndex()).getP() + "'" : "--") + " " + DebugUtils.flagToString((String)"primary", (boolean)this.isPrimary) + " " + DebugUtils.flagToString((String)"trans", (boolean)this.effectiveTransitive) + "" + "(" + DebugUtils.flagToString((String)"flag", (boolean)this.flagTransitive) + ") " + DebugUtils.flagToString((String)"symm", (boolean)this.effectiveSymmetric) + "" + "(" + DebugUtils.flagToString((String)"flag", (boolean)this.flagSymmetric) + ") " + DebugUtils.flagToString((String)"dirty", (boolean)this.isDirtyInf);
    }

    private void do__setNoInverseIndexAndClearAll() {
        this.inverseIndex = null;
        this.isPrimary = true;
        this.effectiveSymmetric = this.flagSymmetric;
        this.effectiveTransitive = this.flagTransitive;
        this.do__clearBase();
        this.do__clearInfd();
    }

    private final boolean do__setSymmetric(boolean symmetric) {
        boolean changes = this.flagSymmetric != symmetric;
        this.flagSymmetric = symmetric;
        return changes;
    }

    @Override
    public final void do__setToSecondaryWithPrimaryInverseIndex(IInverseTransitiveTupleIndex<T> primaryInverseIndex) {
        assert (primaryInverseIndex != null);
        if (log.isDebugEnabled()) {
            log.debug("Set '" + this.getP() + "'.inverseIndex = '" + primaryInverseIndex.getP() + "'");
        }
        this.inverseIndex = (ITTI_Base)primaryInverseIndex;
        this.do__markInferenceAsDirty();
        this.isPrimary = false;
    }

    private final boolean do__setTransitive(boolean transitive) {
        boolean changes = this.flagTransitive != transitive;
        this.flagTransitive = transitive;
        return changes;
    }

    protected final String do__toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.do__metaDataToString() + "\n");
        this.do__contentToString(buf);
        return buf.toString();
    }

    protected abstract Iterator<KeyEntryTuple<T, T>> do__tupleIterator(Constraint<T> var1, Constraint<T> var2);

    @Override
    public final void dump(boolean dumpAll) {
        if (dumpAll && this.isSecondary()) {
            if (log.isInfoEnabled()) {
                log.info("...see at inverse '" + ((ITTI_Base)this.getInverseIndex()).getP() + "'");
            }
            return;
        }
        if (this.isSecondary()) {
            ((ITTI_Base)this.getInverseIndex()).primary__dump();
        } else {
            this.primary__dump();
        }
    }

    @Override
    public final ITTI_Base<T> getInverseIndex() {
        return this.inverseIndex;
    }

    @Override
    public final T getP() {
        return this.p;
    }

    @Override
    public final boolean hasInverse() {
        if (this.getInverseIndex() != null) {
            assert (!this.effectiveSymmetric);
            return true;
        }
        return false;
    }

    protected final boolean hasSecondary() {
        return this.hasInverse() && this.isPrimary();
    }

    @Override
    public final boolean index(T a, T b) {
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).primary__index(b, a);
        }
        return this.primary__index(a, b);
    }

    @Override
    public void inferAll() {
        this.checkAssertions();
        this.primary__inference();
    }

    public final boolean isConcurrent() {
        return this.concurrent;
    }

    @Override
    public final boolean isEmpty() {
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).primary__isEmpty();
        }
        return this.primary__isEmpty();
    }

    protected final boolean isInferenceComplete() {
        return !this.isDirtyInf;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public final boolean isSecondary() {
        assert (this.isPrimary() || this.inverseIndex != null);
        return !this.isPrimary();
    }

    @Override
    public final boolean isSymmetric() {
        this.checkAssertions();
        return this.isPrimary() ? this.primary__isSymmetric() : ((ITTI_Base)this.getInverseIndex()).primary__isSymmetric();
    }

    @Override
    public final boolean isTransitive() {
        return this.isPrimary() ? this.primary__isTransitive() : ((ITTI_Base)this.getInverseIndex()).primary__isTransitive();
    }

    public abstract Iterator<KeyEntryTuple<T, T>> primary__baseTupleIterator();

    protected abstract void primary__clearAll();

    protected final void primary__clearInf() {
        this.do__clearInfd();
        if (this.hasSecondary()) {
            ((ITTI_Base)this.getInverseIndex()).do__clearInfd();
        }
    }

    protected abstract boolean primary__contains(Constraint<T> var1, Constraint<T> var2, InfLayerRead var3);

    protected abstract boolean primary__contains(T var1, T var2, InfLayerRead var3);

    protected abstract boolean primary__deIndex(T var1, T var2);

    protected final void primary__dump() {
        if (!this.isInferenceComplete()) {
            this.primary__inference();
        }
        this.do__dump();
        if (this.hasSecondary()) {
            log.info("=== Secondary: ");
            ((ITTI_Base)this.getInverseIndex()).do__dump();
        }
    }

    protected final void primary__ensureInference() {
        if (this.primary__usesInference() && this.isDirtyInf) {
            if (log.isDebugEnabled()) {
                log.debug("dirty flag set -> inferring");
            }
            this.primary__inference();
        }
    }

    protected abstract boolean primary__index(T var1, T var2);

    protected abstract void primary__inference();

    protected abstract boolean primary__isEmpty();

    protected final boolean primary__isSymmetric() {
        return this.effectiveSymmetric;
    }

    protected final boolean primary__isTransitive() {
        return this.effectiveTransitive;
    }

    protected abstract Iterator<T> primary__query_aX_project_X(Constraint<T> var1, InfLayerRead var2);

    private final void primary__setSymmetric(boolean symmetric) throws IllegalStateException {
        if (symmetric == this.effectiveSymmetric) {
            return;
        }
        this.effectiveSymmetric = symmetric;
    }

    private final void primary__setTransitive(boolean transitive) {
        if (transitive == this.primary__isTransitive()) {
            return;
        }
        this.effectiveTransitive = transitive;
        if (transitive) {
            this.do__markInferenceAsDirty();
        } else {
            this.clearInf();
            this.do__markInferenceAsDirty();
        }
    }

    protected abstract Iterator<KeyEntryTuple<T, T>> primary__tupleIterator(Constraint<T> var1, Constraint<T> var2, InfLayerRead var3);

    protected abstract Iterator<KeyEntryTuple<T, T>> primary__tuples(InfLayerRead var1);

    protected final boolean primary__usesInference() {
        return this.primary__isSymmetric() || this.primary__isTransitive();
    }

    @Override
    public final Iterator<T> query_aX_project_X(Constraint<T> cA, InfLayerRead infLayer) {
        if (this.isSecondary()) {
            throw new IllegalStateException("inefficient query");
        }
        return this.primary__query_aX_project_X(cA, infLayer);
    }

    @Override
    public final Iterator<T> query_Xb_project_X(Constraint<T> cB, InfLayerRead infLayer) {
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).primary__query_aX_project_X(cB, infLayer);
        }
        throw new IllegalStateException("inefficient query");
    }

    @Override
    public final void setNoInverseIndexAndClearAll() {
        if (!this.hasInverse()) {
            return;
        }
        assert (this.hasInverse());
        assert (!this.isSymmetric());
        super.do__setNoInverseIndexAndClearAll();
        this.do__setNoInverseIndexAndClearAll();
    }

    @Override
    public final boolean setSymmetricFlag(boolean symmetric) {
        boolean changes = this.do__setSymmetric(symmetric);
        if (!changes) {
            return false;
        }
        if (this.isPrimary()) {
            this.primary__setSymmetric(symmetric);
        } else {
            super.primary__setSymmetric(symmetric);
        }
        return true;
    }

    @Override
    public final void setToPrimaryWithInverseIndex(IInverseTransitiveTupleIndex<T> secondaryInverseIndex) {
        if (log.isDebugEnabled()) {
            log.debug("Set '" + this.getP() + "'.inverseIndex = '" + secondaryInverseIndex.getP() + "'");
        }
        this.checkAssertions();
        if (secondaryInverseIndex.getP().equals(this.getP())) {
            throw new IllegalArgumentException("Cannot set an index as inverse to itself/same P. Use setSymmetric(..) instead.");
        }
        this.inverseIndex = (ITTI_Base)secondaryInverseIndex;
        this.do__markInferenceAsDirty();
        this.isPrimary = true;
        secondaryInverseIndex.do__setToSecondaryWithPrimaryInverseIndex(this);
        this.primary__inference();
        Iterator<KeyEntryTuple<T, T>> invIt = this.inverseIndex.do__tupleIterator(this.ANY, this.ANY);
        while (invIt.hasNext()) {
            KeyEntryTuple<T, T> t = invIt.next();
            this.index(t.getSecond(), t.getFirst());
        }
        this.inverseIndex.primary__clearAll();
        assert (this.isInferenceComplete());
        assert (this.isPrimary());
        this.checkAssertions();
    }

    @Override
    public final boolean setTransitiveFlag(boolean transitive) {
        boolean changes = this.do__setTransitive(transitive);
        if (!changes) {
            return false;
        }
        if (this.isPrimary()) {
            this.primary__setTransitive(transitive);
        } else {
            super.primary__setTransitive(transitive);
        }
        return true;
    }

    public final String toString() {
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).do__toString();
        }
        return this.do__toString();
    }

    @Override
    public final String toString(boolean dumpAll) {
        if (dumpAll && this.isSecondary() && log.isInfoEnabled()) {
            return "...see at inverse '" + ((ITTI_Base)this.getInverseIndex()).getP() + "'";
        }
        if (this.isSecondary()) {
            return ((ITTI_Base)this.getInverseIndex()).do__toString();
        }
        return this.do__toString();
    }

    @Override
    public final Iterator<KeyEntryTuple<T, T>> tupleIterator(Constraint<T> cA, Constraint<T> cB, InfLayerRead infLayer) {
        if (this.isSecondary()) {
            return ITTI_Base.invert(((ITTI_Base)this.getInverseIndex()).primary__tupleIterator(cB, cA, infLayer));
        }
        return this.primary__tupleIterator(cA, cB, infLayer);
    }

    @Override
    public final Iterator<KeyEntryTuple<T, T>> tuples(InfLayerRead infLayer) {
        if (this.isSecondary()) {
            return ITTI_Base.invert(((ITTI_Base)this.getInverseIndex()).primary__tuples(infLayer));
        }
        return this.primary__tuples(infLayer);
    }
}

