/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tupleinf;

import de.xam.tupleinf.CombinedEntrySet;
import java.io.Serializable;
import java.util.Iterator;
import org.xydra.index.IEntrySet;
import org.xydra.index.IMapSetIndex;
import org.xydra.index.ISerializableMapSetIndex;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.KeyEntryTuple;

public class CombinedTupleIndex<K extends Serializable, E extends Serializable>
implements ISerializableMapSetIndex<K, E> {
    private final IMapSetIndex<K, E> a;
    private final IMapSetIndex<K, E> b;

    public CombinedTupleIndex(IMapSetIndex<K, E> a, IMapSetIndex<K, E> b) {
        this.a = a;
        this.b = b;
    }

    public static <K extends Serializable, E extends Serializable> IMapSetIndex<K, E> combine(IMapSetIndex<K, E> a, IMapSetIndex<K, E> b) {
        if (a == b) {
            return a;
        }
        return new CombinedTupleIndex<K, E>(a, b);
    }

    public void clear() {
        this.a.clear();
        this.b.clear();
    }

    public boolean isEmpty() {
        return this.a.isEmpty() && this.b.isEmpty();
    }

    public ClosableIterator<E> constraintIterator(Constraint<K> c1) {
        return Iterators.concat((Iterator)this.a.constraintIterator(c1), (Iterator)this.b.constraintIterator(c1));
    }

    public boolean contains(Constraint<K> c1, Constraint<E> entryConstraint) {
        return this.a.contains(c1, entryConstraint) || this.b.contains(c1, entryConstraint);
    }

    public boolean contains(K k, E e) {
        return this.a.contains(k, e) || this.b.contains(k, e);
    }

    public boolean containsKey(K key) {
        return this.a.containsKey(key) || this.b.containsKey(key);
    }

    public boolean deIndex(K key1, E entry) {
        if (this.a.contains(key1, entry)) {
            return false;
        }
        return this.b.deIndex(key1, entry);
    }

    public boolean deIndex(K key1) {
        return this.b.deIndex(key1);
    }

    public boolean index(K key1, E entry) {
        if (this.a.contains(key1, entry)) {
            return false;
        }
        return this.b.index(key1, entry);
    }

    public Iterator<KeyEntryTuple<K, E>> tupleIterator(Constraint<K> c1, Constraint<E> entryConstraint) {
        return Iterators.concat((Iterator)this.a.tupleIterator(c1, entryConstraint), (Iterator)this.b.tupleIterator(c1, entryConstraint));
    }

    public Iterator<K> keyIterator() {
        return Iterators.concat((Iterator)this.a.keyIterator(), (Iterator)this.b.keyIterator());
    }

    public IMapSetIndex.IMapSetDiff<K, E> computeDiff(IMapSetIndex<K, E> otherFuture) {
        throw new UnsupportedOperationException();
    }

    public IEntrySet<E> lookup(K key) {
        return CombinedEntrySet.combine(this.a.lookup(key), this.b.lookup(key));
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder b = new StringBuilder();
        b.append(indent + "A:\n");
        b.append(indent + this.a.toString());
        b.append(indent + "B:\n");
        b.append(indent + b.toString());
        return b.toString();
    }
}

