/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ServletUtils {
    public static final String CONTENTTYPE_APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String CONTENTTYPE_STAR_STAR = "*/*";
    public static final String CONTENTTYPE_TEXT_HTML = "text/html";
    public static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_REFERER = "Referer";
    public static final String CONTENTTYPE_APPLICATION_JSON = "application/json.";
    private static Logger log = LoggerFactory.getThreadSafeLogger(ServletUtils.class);

    public static String conneg(HttpServletRequest req) {
        Double q;
        Enumeration enu = req.getHeaders(HEADER_ACCEPT);
        assert (enu != null) : "Container allows no header access";
        HashMap<String, Double> contentType2q = new HashMap<String, Double>();
        while (enu.hasMoreElements()) {
            String[] headerValues;
            String headerValue = (String)enu.nextElement();
            for (String s : headerValues = headerValue.split(",")) {
                ServletUtils.parseAcceptHeaderPart(s, contentType2q);
            }
        }
        if (contentType2q.containsKey(CONTENTTYPE_APPLICATION_XHTML_XML) && ((q = (Double)contentType2q.get(CONTENTTYPE_APPLICATION_XHTML_XML)) == null || q > 0.0)) {
            return CONTENTTYPE_APPLICATION_XHTML_XML;
        }
        if (contentType2q.containsKey(CONTENTTYPE_TEXT_HTML) && ((q = (Double)contentType2q.get(CONTENTTYPE_TEXT_HTML)) == null || q > 0.0)) {
            return CONTENTTYPE_TEXT_HTML;
        }
        if (contentType2q.containsKey(CONTENTTYPE_STAR_STAR)) {
            return CONTENTTYPE_TEXT_HTML;
        }
        log.warn("Could not extract meaningful wish from accept header, using oldschool html");
        return CONTENTTYPE_TEXT_HTML;
    }

    public static Map<String, String> getCookiesAsMap(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if (cookieMap.containsKey(name)) {
                    log.info("Found multiple cookies with the name '" + name + "' with values. Using last one. E.g., '" + (String)cookieMap.get(name) + "' is overwritten by '" + value + "'");
                }
                cookieMap.put(name, value);
            }
        }
        return cookieMap;
    }

    public static Map<String, List<String>> getHeadersAsMap(HttpServletRequest req) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Enumeration en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Enumeration valueEn = req.getHeaders(name);
            LinkedList<String> valueList = new LinkedList<String>();
            while (valueEn.hasMoreElements()) {
                valueList.add((String)valueEn.nextElement());
            }
            map.put(name, valueList);
        }
        return map;
    }

    public static final String getPageUri(HttpServletRequest req) {
        return req.getProtocol() + req.getRemoteHost() + req.getRequestURI();
    }

    public static Map<String, SortedSet<String>> getQueryStringAsMap(String queryString) {
        String[] pairs;
        HashMap<String, SortedSet<String>> map = new HashMap<String, SortedSet<String>>();
        if (queryString == null) {
            return map;
        }
        for (String pair : pairs = queryString.split("[&;]")) {
            int equalSignIndex = pair.indexOf("=");
            if (equalSignIndex > 0) {
                String first = pair.substring(0, equalSignIndex);
                String second = pair.substring(equalSignIndex + 1, pair.length());
                ServletUtils.addRawKeyValue(map, first, second);
                continue;
            }
            ServletUtils.addRawKeyValue(map, pair, null);
        }
        return map;
    }

    private static void addRawKeyValue(Map<String, SortedSet<String>> map, String rawKey, String rawValue) {
        assert (rawKey != null);
        assert (!rawKey.equals(""));
        try {
            String key = URLDecoder.decode(rawKey, "utf-8");
            if (key != null && !key.equals("")) {
                SortedSet<String> values = map.get(key);
                if (values == null) {
                    values = new TreeSet<String>();
                    map.put(key, values);
                }
                if (rawValue != null) {
                    String value = URLDecoder.decode(rawValue, "utf-8");
                    values.add(value);
                } else {
                    values.add("");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No utf-8 on this system?", e);
        }
    }

    public static String getReferrerUrl(HttpServletRequest req) {
        return req.getHeader(HEADER_REFERER);
    }

    public static Map<String, String> getRequestparametersAsMap(HttpServletRequest req) throws IllegalStateException {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Object[] values = req.getParameterValues(name);
            Object value = null;
            if (values.length > 0) {
                if (values.length > 1) {
                    log.warn("param '" + name + "' has more than one value, namely " + Arrays.toString(values) + ". Using last one.");
                    value = values[values.length - 1];
                }
                value = values[0];
            }
            map.put(ServletUtils.urldecode(name), ServletUtils.urldecode(value));
        }
        return map;
    }

    public static final String getServerUri(HttpServletRequest req) {
        return req.getProtocol() + req.getRemoteHost();
    }

    public static boolean hasParameter(HttpServletRequest req, String paramName) {
        if (paramName == null) {
            return false;
        }
        return req.getParameter(paramName) != null;
    }

    public static void headers(HttpServletResponse res, int status, long cachingInMinutes, String contentType) {
        res.setCharacterEncoding("utf-8");
        res.setContentType(contentType);
        if (status > 0) {
            res.setStatus(status);
        }
        if (cachingInMinutes == -1L) {
            ServletUtils.setNoCacheHeaders(res);
        } else if (cachingInMinutes > 0L) {
            long millisSinceEpoch = System.currentTimeMillis() + cachingInMinutes * 60L * 1000L;
            res.setDateHeader("Expires", millisSinceEpoch);
            res.setHeader("Cache-Control", "private");
        }
    }

    public static void headers(HttpServletResponse res, String contentType) {
        res.setCharacterEncoding("utf-8");
        res.setContentType(contentType);
        res.setStatus(200);
        ServletUtils.setNoCacheHeaders(res);
    }

    public static void setNoCacheHeaders(HttpServletResponse res) {
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        res.setDateHeader("Expires", 0L);
        res.setHeader("Expires", "Fri, 01 Jan 1990 00:00:00 GMT");
    }

    public static void headersXhtmlViaConneg(HttpServletRequest req, HttpServletResponse res, int status, long cachingInMinutes) {
        String chosenContentType = ServletUtils.conneg(req);
        ServletUtils.headers(res, status, cachingInMinutes, chosenContentType);
    }

    public static boolean isInsecureHttpRequest(HttpServletRequest req) {
        return req.getScheme().equals("http");
    }

    public static boolean isRequestToRoot(HttpServletRequest req) {
        String path = req.getPathInfo();
        return path == null || path.equals("") || path.equals("/");
    }

    public static boolean isSecureHttpsRequest(HttpServletRequest req) {
        return req.getScheme().equals("https");
    }

    public static boolean isSet(String paramValue) {
        return paramValue != null && !paramValue.equals("");
    }

    private static void parseAcceptHeaderPart(String headerValue, Map<String, Double> contentType2q) {
        String[] parts = headerValue.split(";");
        String contentDef = parts[0];
        if (parts.length > 1) {
            String qs = parts[1].trim();
            if (!qs.startsWith("q=")) {
                log.warn("q-value '" + qs + "' wrong in Accept header '" + headerValue + "'");
            } else {
                qs = qs.substring(2);
                try {
                    double q = Double.parseDouble(qs);
                    contentType2q.put(contentDef, q);
                }
                catch (NumberFormatException e) {
                    log.warn("q-value '" + qs + "' not parsable as double in Accept header '" + headerValue + "'");
                }
            }
        } else {
            contentType2q.put(contentDef, null);
        }
    }

    public static Map<String, String> parseQueryString(String q) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : pairs = q.split("\\&")) {
            String[] parts = s.split("=");
            String key = parts[0];
            String value = parts.length > 1 ? parts[1] : null;
            map.put(key, value);
        }
        return map;
    }

    public static String urldecode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean toBoolean(String b) {
        if (!ServletUtils.isSet(b)) {
            return false;
        }
        assert (b != null);
        String c = b.trim().toLowerCase();
        return c.equals("true") || c.equals("yes") || c.equals("on");
    }
}

