/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.xydra.annotations.LicenseApache;

@LicenseApache(project="Apache HttpComponents")
public class QueryStringUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char QP_SEP_A = '&';
    private static final char QP_SEP_S = ';';
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final char[] QP_SEPS = new char[]{'&', ';'};
    private static final String QP_SEP_PATTERN = "[" + new String(QP_SEPS) + "]";

    public static Map<String, List<String>> parse(String queryString, Charset charset) {
        if (queryString != null && queryString.length() > 0) {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            Scanner scanner = new Scanner(queryString);
            QueryStringUtils.parse(result, scanner, QP_SEP_PATTERN, charset);
            return result;
        }
        return Collections.emptyMap();
    }

    public static Map<String, List<String>> parse(String queryString) {
        return QueryStringUtils.parse(queryString, UTF8);
    }

    public static Map<String, List<String>> parse(URI uri) {
        String query = uri.getRawQuery();
        return QueryStringUtils.parse(query);
    }

    private static void parse(Map<String, List<String>> parameters, Scanner scanner, String parameterSepartorPattern, Charset charset) {
        scanner.useDelimiter(parameterSepartorPattern);
        while (scanner.hasNext()) {
            String name = null;
            String value = null;
            String token = scanner.next();
            int i = token.indexOf(NAME_VALUE_SEPARATOR);
            if (i != -1) {
                name = QueryStringUtils.decodeFormFields(token.substring(0, i).trim(), charset);
                value = QueryStringUtils.decodeFormFields(token.substring(i + 1).trim(), charset);
            } else {
                name = QueryStringUtils.decodeFormFields(token.trim(), charset);
            }
            List<String> list = parameters.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                parameters.put(name, list);
            }
            list.add(value);
        }
    }

    private static String decodeFormFields(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return QueryStringUtils.urlDecode(content, charset, true);
    }

    private static String urlDecode(String content, Charset charset, boolean plusAsBlank) {
        if (content == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            if (plusAsBlank && c == '+') {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return charset.decode(bb).toString();
    }
}

