/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.ServletUtils;

public class FileDownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadUtils.class);

    public static ZipOutputStream toZipFileDownload(HttpServletResponse res, String archivename) throws IOException {
        String fullArchiveName = archivename + ".zip";
        log.info("Wrapping in zipfile named " + fullArchiveName);
        res.setContentType("application/zip");
        res.addHeader("Content-Disposition", "attachment; filename=\"" + fullArchiveName + "\"");
        ZipOutputStream zos = new ZipOutputStream((OutputStream)res.getOutputStream());
        return zos;
    }

    public static OutputStream toFileDownload(HttpServletResponse res, String archivename, String extension) throws IOException {
        String fullFileName = archivename + "." + extension;
        log.info("Wrapping in file named " + fullFileName);
        res.addHeader("Content-Disposition", "attachment; filename=\"" + fullFileName + "\"");
        ServletOutputStream os = res.getOutputStream();
        return os;
    }

    public static OutputStream toFileDownload(HttpServletResponse res, String archivename, String extension, String contentType) throws IOException {
        ServletUtils.headers(res, contentType);
        return FileDownloadUtils.toFileDownload(res, archivename, extension);
    }
}

