/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EchoServlet
extends HttpServlet {
    private static final long serialVersionUID = 4266214485819030466L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        EchoServlet.echo(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        EchoServlet.echo(req, resp);
    }

    private static void echo(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType("text/plain");
        PrintWriter w = resp.getWriter();
        w.println("Got request.");
        w.println("== Request ==");
        w.println(" * schema: " + req.getScheme());
        w.println(" * protocol: " + req.getProtocol());
        w.println(" * method: " + req.getMethod());
        w.println(" * encoding: " + req.getCharacterEncoding());
        w.println(" * contentType: " + req.getContentType());
        w.println(" * contentLength: " + req.getContentLength());
        w.println(" * authType: " + req.getAuthType());
        if (req.getCookies() != null) {
            w.println("=== Cookies ===");
            for (Cookie cookie : req.getCookies()) {
                w.println(cookie.getName());
                w.println(" * version: " + cookie.getVersion());
                w.println(" * domain: " + cookie.getDomain());
                w.println(" * path: " + cookie.getPath());
                w.println(" * maxAge: " + cookie.getMaxAge());
                w.println(" * value: " + cookie.getValue());
                w.println(" * comment: " + cookie.getComment());
            }
        }
        w.println("=== Headers ===");
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            w.println(headerName);
            Enumeration headerValues = req.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                w.println(" * " + headerValue);
            }
        }
        w.println("");
        w.println("== Payload ==");
        w.println("=== Request Parameters ===");
        Enumeration parameters = req.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            for (String paramValue : req.getParameterValues(paramName)) {
                w.println(" * " + paramName + " = " + paramValue);
            }
        }
        w.println("=== Path ===");
        w.println(" * requestURI: " + req.getRequestURI());
        w.println(" * requestURL: " + req.getRequestURL());
        w.println(" * contextPath: '" + req.getContextPath() + "'");
        w.println(" * pathInfo: " + req.getPathInfo());
        w.println(" * queryString: " + req.getQueryString());
        w.println(" * remoteAddr: " + req.getRemoteAddr());
        w.println(" * remoteHost: " + req.getRemoteHost());
        w.println(" * remotePort: " + req.getRemotePort());
        w.println(" * remoteUser: " + req.getRemoteUser());
        w.println("== Derrived Information ==");
        w.println(" * client locale: " + req.getLocale());
        w.println(" * pathTranslated: " + req.getPathTranslated());
        w.println(" * sessionId: " + req.getRequestedSessionId());
        w.println("=== Addressing ===");
        w.println(" * localAddr: " + req.getLocalAddr());
        w.println(" * localName: " + req.getLocalName());
        w.println(" * localPort: " + req.getLocalPort());
        w.println("=== Attributes ===");
        Enumeration attributes = req.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attName = (String)attributes.nextElement();
            Object attValue = req.getAttribute(attName);
            w.println(" * " + attName + " = " + attValue.getClass() + " " + attValue.toString());
        }
        w.println("=== Server ===");
        w.println(" * servletName: " + req.getServerName());
        w.println(" * serverPort: " + req.getServerPort());
        w.println(" * servletPath: " + req.getServletPath());
        if (req.getUserPrincipal() != null) {
            w.println(" userPrincipal: " + req.getUserPrincipal().getName());
        }
        w.flush();
        w.println("=== Request Content ===");
        BufferedReader r = req.getReader();
        String line = r.readLine();
        while (line != null) {
            w.println("> " + line);
            line = r.readLine();
        }
        w.close();
    }
}

