/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.xydra.common.NanoClock;
import org.xydra.restless.Restless;

class RestlessStatic {
    RestlessStatic() {
    }

    static void invokeStaticMethodOnInstance(NanoClock clock, Object instance, String staticMethodName, Class<?>[] parameterTypes, Object[] parameters) {
        clock.start();
        Class<?> clazz = instance.getClass();
        String className = clazz.getCanonicalName();
        try {
            Class[] fullParameterTypes = new Class[parameterTypes.length + 1];
            System.arraycopy(parameterTypes, 0, fullParameterTypes, 1, parameterTypes.length);
            fullParameterTypes[0] = clazz;
            Method staticMethod = clazz.getMethod(staticMethodName, parameterTypes);
            clock.stop(className + "-get-method-" + staticMethodName);
            try {
                clock.start();
                staticMethod.invoke(instance, parameters);
                clock.stop(className + "-invoke-method-" + staticMethodName);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Class '" + className + "." + staticMethodName + "(...)' failed with IllegalArgumentException", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Class '" + className + "." + staticMethodName + "(...)' failed with IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Class '" + className + "." + staticMethodName + "(...)' failed with InvocationTargetException", e);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class '" + className + "' has no " + staticMethodName + "( ... ) method.");
        }
    }

    static void invokeStaticMethod(NanoClock clock, String className, String staticMethodName, Class<?>[] parameterTypes, Object[] parameters) {
        clock.start();
        try {
            Class<?> clazz = Class.forName(className);
            try {
                try {
                    try {
                        Constructor<?> cons = clazz.getConstructor(new Class[0]);
                        try {
                            Object instance = cons.newInstance(new Object[0]);
                            clock.stop(className + "-newinstance");
                            RestlessStatic.invokeStaticMethodOnInstance(clock, instance, staticMethodName, parameterTypes, parameters);
                        }
                        catch (IllegalArgumentException e) {
                            throw new RuntimeException("new '" + className + "() failed with " + e.getClass() + ":" + e.getMessage(), e);
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException("new '" + className + "() failed with " + e.getClass() + ":" + e.getMessage(), e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("new '" + className + "() failed with " + e.getClass() + ":" + e.getMessage() + " caused by " + (e.getCause() == null ? "--" : e.getCause().getClass() + ":" + e.getCause().getMessage()), e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException("new '" + className + "() failed with " + e.getClass() + ":" + e.getMessage(), e);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("Class '" + className + "' has no " + staticMethodName + "( ... ) method.");
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("new '" + className + "() failed with " + e.getClass() + ":" + e.getMessage(), e);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Class '" + className + " failed to get constructor", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class '" + className + "' not found");
        }
    }

    static void invokeStaticMethod(String className, String staticMethodName, Class<?>[] parameterTypes, Object[] parameters) {
        NanoClock clock = new NanoClock();
        RestlessStatic.invokeStaticMethod(clock, className, staticMethodName, parameterTypes, parameters);
    }

    public static String getServletPath(HttpServletRequest req) {
        String uri = req.getRequestURI();
        String path = req.getPathInfo();
        String servletPath = uri.substring(0, uri.length() - path.length());
        Restless.log.debug("uri=" + uri + "\npath=" + path + "->" + servletPath);
        return servletPath;
    }

    protected static final String instanceOrClass_className(Object instanceOrClass) {
        if (instanceOrClass instanceof Class) {
            return ((Class)instanceOrClass).getCanonicalName();
        }
        return instanceOrClass.getClass().getName();
    }

    public static Method methodByName(Class<?> clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Method methodByName(Object instanceOrClass, String methodName) {
        return RestlessStatic.methodByName(RestlessStatic.toClass(instanceOrClass), methodName);
    }

    static List<String> parseToList(String commaSeparatedClassnames) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedClassnames == null) {
            return list;
        }
        String[] parts = commaSeparatedClassnames.split("[\\s\\n]*,[\\s\\n]*");
        for (int i = 0; i < parts.length; ++i) {
            String classname = parts[i].trim();
            assert (!classname.contains(","));
            list.add(classname);
        }
        return list;
    }

    static boolean requestIsViaAdminUrl(HttpServletRequest req) {
        return req.getRequestURI().startsWith("/admin");
    }

    public static Class<?> toClass(Object instanceOrClass) {
        if (instanceOrClass instanceof Class) {
            return (Class)instanceOrClass;
        }
        return instanceOrClass.getClass();
    }
}

